/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.beta;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import xyz.pixelatedw.mineminenomi.abilities.blackleg.DiableJambeAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.DamagedContinuousAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IBodyOverlayAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.common.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.common.LogiaParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.IParallelContinuousAbility;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;

public class BetaCoatingAbility
extends DamagedContinuousAbility
implements IParallelContinuousAbility,
IBodyOverlayAbility {
    public static final BetaCoatingAbility INSTANCE = new BetaCoatingAbility();
    private final ArrayList<DamageSource> explosiveSources = new ArrayList<DamageSource>(Arrays.asList(DamageSource.field_76372_a, DamageSource.field_180137_b, DamageSource.field_76370_b, DamageSource.field_76371_c));
    private static final AttributeModifier SPEED_MULTIPLIER = new AttributeModifier(UUID.fromString("efa08cbd-57e5-478f-b15c-6295eb1b375e"), "Beta Speed Multiplier", -0.25, AttributeModifier.Operation.MULTIPLY_TOTAL).func_111168_a(false);
    private static final AbilityOverlay OVERLAY = new AbilityOverlay().setTexture(ModResources.BETA_COATING).setColor(WyHelper.hexToRGB("#FFFFFFA6"));
    boolean exploded = false;

    public BetaCoatingAbility() {
        super("Beta Coating", AbilityHelper.getDevilFruitCategory());
        this.setDescription("Covers the user in a thick mucus coat, which makes them immune to almost all attacks, but extremely vulnerable to fire");
        this.setMaxCooldown(10.0);
        this.onDamagedEvent = this::onDamagedEvent;
        this.onStartContinuityEvent = this::onStartContinuityEvent;
        this.onEndContinuityEvent = this::onEndContinuityEvent;
        this.duringContinuityEvent = this::duringContinuity;
    }

    private boolean onDamagedEvent(LivingEntity entity, DamageSource damageSource, double damage) {
        for (DamageSource s : this.explosiveSources) {
            if (!damageSource.func_76355_l().equals(s.func_76355_l())) continue;
            this.disableAbilityAndExplode(entity);
            return true;
        }
        if (damageSource.func_76364_f() instanceof LivingEntity && damageSource.func_76364_f().func_70027_ad()) {
            return true;
        }
        if (!damageSource.func_94541_c() && !damageSource.func_76347_k()) {
            LogiaParticleEffect particleEffect = new LogiaParticleEffect(ModParticleTypes.BETA);
            ((ParticleEffect)particleEffect).spawn(entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 0.0, 0.0, 0.0);
            return false;
        }
        this.disableAbilityAndExplode(entity);
        return true;
    }

    private boolean onStartContinuityEvent(PlayerEntity player) {
        this.exploded = false;
        player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(SPEED_MULTIPLIER);
        return true;
    }

    private void duringContinuity(PlayerEntity player, int i) {
        DiableJambeAbility ability = AbilityDataCapability.get((LivingEntity)player).getEquippedAbility(DiableJambeAbility.INSTANCE);
        if (player.func_70027_ad() || ability != null && ability.isContinuous()) {
            this.disableAbilityAndExplode((LivingEntity)player);
        }
    }

    private boolean onEndContinuityEvent(PlayerEntity player) {
        player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(SPEED_MULTIPLIER);
        return true;
    }

    private void disableAbilityAndExplode(LivingEntity entity) {
        if (!this.exploded) {
            if (entity instanceof PlayerEntity) {
                this.stopContinuity((PlayerEntity)entity);
            }
            this.exploded = true;
            entity.func_70066_B();
            ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)entity, entity.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 6.0f);
            explosion.setExplosionSound(true);
            explosion.setDamageOwner(true);
            explosion.setDestroyBlocks(true);
            explosion.setFireAfterExplosion(true);
            explosion.setStaticDamage(100.0f);
            explosion.setSmokeParticles(new CommonExplosionParticleEffect(6));
            explosion.setDamageEntities(true);
            explosion.doExplosion();
        }
    }

    @Override
    public AbilityOverlay getBodyOverlay() {
        return OVERLAY;
    }
}

