/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.beta;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.Vec3d;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.beta.HanamizuShinkenShirahadoriEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ContinuousAbility;

public class HanamizuShinkenAbility
extends ContinuousAbility {
    public static final HanamizuShinkenAbility INSTANCE = new HanamizuShinkenAbility();
    private ParticleEffect particles = new HanamizuShinkenShirahadoriEffect();

    public HanamizuShinkenAbility() {
        super("Hanamizu Shinken Shirahadori", AbilityHelper.getDevilFruitCategory());
        this.setThreshold(3.0);
        this.setDescription("Creates a protecting wall of mucus, protecting the user from attacks");
        this.duringContinuityEvent = this::duringContinuity;
        this.onEndContinuityEvent = this::onEndContinuityEvent;
    }

    private void duringContinuity(PlayerEntity player, int passiveTimer) {
        player.func_195064_c(new EffectInstance(ModEffects.MOVEMENT_BLOCKED, 5, 0, false, false));
        int range = 2;
        double boxSize = 1.2;
        for (int i = 0; i < range * 2; ++i) {
            double distance = (double)i / 2.0;
            Vec3d lookVec = player.func_70040_Z();
            Vec3d pos = new Vec3d(player.func_226277_ct_() + lookVec.field_72450_a * distance, player.func_226278_cu_() + (double)player.func_70047_e() + lookVec.field_72448_b * distance, player.func_226281_cx_() + lookVec.field_72449_c * distance);
            List list = player.field_70170_p.func_175674_a((Entity)player, new AxisAlignedBB(pos.field_72450_a - boxSize, pos.field_72448_b - boxSize, pos.field_72449_c - boxSize, pos.field_72450_a + boxSize, pos.field_72448_b + boxSize * 2.0, pos.field_72449_c + boxSize), entity -> entity != player);
            for (Entity e : list) {
                if (e instanceof LivingEntity) {
                    e.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), 4.0f);
                    ((LivingEntity)e).func_195064_c(new EffectInstance(Effects.field_76421_d, 200, 4));
                    Vec3d speed = WyHelper.propulsion((LivingEntity)player, 3.0, 3.0);
                    e.func_213293_j(speed.field_72450_a, 0.5, speed.field_72449_c);
                    e.field_70133_I = true;
                    continue;
                }
                if (!(e instanceof ThrowableEntity) && !(e instanceof AbstractArrowEntity)) continue;
                e.func_213293_j(-e.func_213322_ci().field_72450_a, e.func_213322_ci().field_72448_b, -e.func_213322_ci().field_72450_a);
            }
        }
        EntityRayTraceResult trace = WyHelper.rayTraceEntities((Entity)player, range);
        if (passiveTimer % 2 == 0) {
            this.particles.spawn(player.field_70170_p, trace.func_216347_e().func_82615_a(), player.func_226278_cu_(), trace.func_216347_e().func_82616_c(), 0.0, 0.0, 0.0);
        }
    }

    private boolean onEndContinuityEvent(PlayerEntity player) {
        int cooldown = 2 + (int)Math.round((double)this.continueTime / 20.0);
        this.setMaxCooldown(cooldown);
        return true;
    }
}

