/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.blackleg;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.blackleg.ExtraHachisProjectile;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.blackleg.ExtraHachiParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.RepeaterAbility;

public class ExtraHachisAbility
extends RepeaterAbility {
    public static final ExtraHachisAbility INSTANCE = new ExtraHachisAbility();
    private static final ParticleEffect PARTICLES = new ExtraHachiParticleEffect();
    private boolean diableJambeMode = false;

    public ExtraHachisAbility() {
        super("Extra Hachis", AbilityHelper.getStyleCategory());
        this.setMaxCooldown(12.0);
        this.setMaxRepeaterCount(20, 2);
        this.setDescription("Launches a rapid barrage of kicks");
        this.onUseEvent = this::onUseEvent;
    }

    private boolean onUseEvent(PlayerEntity player) {
        ExtraHachisProjectile projectile = new ExtraHachisProjectile(player.field_70170_p, (LivingEntity)player);
        int projectileSpace = 2;
        float speed = 2.0f;
        if (this.diableJambeMode) {
            projectile.setDamage(4.0f);
            projectile.onEntityImpactEvent = entity -> entity.func_70015_d(2);
            projectile.onTickEvent = () -> PARTICLES.spawn(player.field_70170_p, projectile.func_226277_ct_(), projectile.func_226278_cu_(), projectile.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
        projectile.func_70012_b(player.func_226277_ct_() + WyHelper.randomWithRange(-projectileSpace, projectileSpace) + WyHelper.randomDouble(), player.func_226278_cu_() + 0.3 + WyHelper.randomWithRange(0, projectileSpace) + WyHelper.randomDouble(), player.func_226281_cx_() + WyHelper.randomWithRange(-projectileSpace, projectileSpace) + WyHelper.randomDouble(), 0.0f, 0.0f);
        player.field_70170_p.func_217376_c((Entity)projectile);
        projectile.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, speed, 3.0f);
        ((ServerWorld)player.field_70170_p).func_72863_F().func_217216_a((Entity)player, (IPacket)new SAnimateHandPacket((Entity)player, 0));
        return true;
    }

    public void enableDiableJambeMode() {
        this.setDisplayName("Po\u00eale \u00e0 Frire");
        this.setCustomTexture("poele_a_frire");
        this.setMaxCooldown(15.0);
        this.diableJambeMode = true;
    }

    public void disableDiableJambeMode() {
        this.setDisplayName(null);
        this.setCustomTexture("");
        this.setMaxCooldown(12.0);
        this.diableJambeMode = false;
    }
}

