/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.bomu;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.particles.effects.common.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;

public class ZenshinKibakuAbility
extends ChargeableAbility {
    public static final ZenshinKibakuAbility INSTANCE = new ZenshinKibakuAbility();
    private int power = 0;

    public ZenshinKibakuAbility() {
        super("Zenshin Kibaku", AbilityHelper.getDevilFruitCategory());
        this.setMaxCooldown(30.0);
        this.setDescription("The user creates a massive explosion from their body");
        this.setMaxChargeTime(5.0);
        this.setCancelable();
        this.duringChargingEvent = this::duringChargingEvent;
        this.onEndChargingEvent = this::onEndChargingEvent;
    }

    private void duringChargingEvent(PlayerEntity player, int timer) {
        this.power = timer;
    }

    private boolean onEndChargingEvent(PlayerEntity player) {
        float power = (float)(this.getMaxChargeTime() - this.power) / 20.0f * 2.0f;
        ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)player, player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), power);
        explosion.setSmokeParticles(new CommonExplosionParticleEffect((int)power));
        explosion.setStaticDamage(power * 12.0f);
        explosion.doExplosion();
        return true;
    }
}

