/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.brawler;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IMultiTargetAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.particles.effects.common.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.PunchAbility;

public class HakaiHoAbility
extends PunchAbility
implements IMultiTargetAbility {
    public static final HakaiHoAbility INSTANCE = new HakaiHoAbility();

    public HakaiHoAbility() {
        super("Hakai Ho", AbilityHelper.getStyleCategory());
        this.setDescription("The user punches with enough force to create an explosion");
        this.setMaxCooldown(10.0);
        this.onHitEntityEvent = this::onHitEntity;
    }

    private float onHitEntity(PlayerEntity player, LivingEntity target) {
        this.clearTargets();
        if (!AbilityHelper.canUseBrawlerAbilities((LivingEntity)player)) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_FIST, new Object[0]));
            return 1.0f;
        }
        List<LivingEntity> targets = WyHelper.getEntitiesNear(target.func_180425_c(), target.field_70170_p, 2.0);
        targets.remove(player);
        for (LivingEntity aoeTarget : targets) {
            if (!this.isTarget(aoeTarget)) continue;
            aoeTarget.func_70097_a((DamageSource)ModDamageSource.causeAbilityDamage(player, this), 10.0f);
            aoeTarget.func_195064_c(new EffectInstance(ModEffects.DIZZY, 100, 0, false, false));
            Vec3d speed = WyHelper.propulsion((LivingEntity)player, 3.0, 3.0);
            aoeTarget.func_213293_j(speed.field_72450_a, 0.5, speed.field_72449_c);
            aoeTarget.field_70133_I = true;
        }
        ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)target, target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), 2.0f);
        explosion.setStaticDamage(15.0f);
        explosion.setDestroyBlocks(false);
        explosion.setDamageEntities(false);
        explosion.setSmokeParticles(new CommonExplosionParticleEffect(2));
        explosion.doExplosion();
        return 10.0f;
    }
}

