/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.brawler;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.common.BlockParticlesEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;

public class JishinHoAbility
extends Ability {
    public static final JishinHoAbility INSTANCE = new JishinHoAbility();
    public static final ParticleEffect PARTICLES = new BlockParticlesEffect(7, 100);

    public JishinHoAbility() {
        super("Jishin Ho", AbilityHelper.getStyleCategory());
        this.setDescription("Punches the ground to cause a quake that damages everyone around");
        this.setMaxCooldown(15.0);
        this.onUseEvent = this::onUseEvent;
    }

    private boolean onUseEvent(PlayerEntity player) {
        if (!AbilityHelper.canUseBrawlerAbilities((LivingEntity)player)) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_FIST, new Object[0]));
            return false;
        }
        for (int i = 0; i < 30; ++i) {
            PARTICLES.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
        List targets = WyHelper.getEntitiesNear(player.func_180425_c(), player.field_70170_p, 7.0, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), LivingEntity.class);
        targets.removeIf(entity -> !entity.field_70122_E);
        targets.remove(player);
        targets.stream().filter(target -> target != null && target.func_70089_S() && target.func_70685_l((Entity)player)).forEach(target -> {
            target.func_70097_a((DamageSource)ModDamageSource.causeAbilityDamage(player, this), 25.0f);
            target.func_213293_j(0.0, 0.75, 0.0);
            target.field_70133_I = true;
        });
        return true;
    }
}

