/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.cyborg;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncEntityStatsPacket;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

public class ColaOverdriveAbility
extends Ability {
    public static final Ability INSTANCE = new ColaOverdriveAbility();

    public ColaOverdriveAbility() {
        super("Cola Overdrive", AbilityHelper.getRacialCategory());
        this.setMaxCooldown(50.0);
        this.setDescription("The user absorbs half of their cola at once to boost their physical abilities temporarily");
        this.onUseEvent = this::onUseEvent;
    }

    private boolean onUseEvent(PlayerEntity player) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        double half = (float)props.getMaxCola() / 2.0f;
        if ((double)props.getCola() - half < 0.0) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NOT_ENOUGH_COLA, new Object[0]));
            return false;
        }
        props.setCola((int)((double)props.getCola() - half));
        WyNetwork.sendTo(new SSyncEntityStatsPacket(player.func_145782_y(), props), player);
        player.func_70691_i((float)(half / 1000.0 * player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b()));
        player.func_195064_c(new EffectInstance(Effects.field_76429_m, 300, 1));
        player.func_195064_c(new EffectInstance(Effects.field_76424_c, 300, 2));
        player.func_195064_c(new EffectInstance(Effects.field_76420_g, 300, 3));
        return true;
    }
}

