/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.cyborg;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncEntityStatsPacket;
import xyz.pixelatedw.mineminenomi.particles.data.GenericParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

public class CoupDeBooAbility
extends Ability {
    public static final Ability INSTANCE = new CoupDeBooAbility();

    public CoupDeBooAbility() {
        super("Coup De Boo", AbilityHelper.getRacialCategory());
        this.setMaxCooldown(15.0);
        this.setDescription("Launches the user into the sky");
        this.onUseEvent = this::onUseEvent;
    }

    private boolean onUseEvent(PlayerEntity player) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        if (props.getCola() - 100 < 0) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NOT_ENOUGH_COLA, new Object[0]));
            return false;
        }
        Vec3d speed = WyHelper.propulsion((LivingEntity)player, 2.0, 1.5, 2.0);
        player.func_213293_j(speed.field_72450_a, speed.field_72448_b + 3.5, speed.field_72449_c);
        props.setCola(props.getCola() - 100);
        WyNetwork.sendTo(new SSyncEntityStatsPacket(player.func_145782_y(), props), player);
        ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket((Entity)player));
        this.spawnParticles((ServerWorld)player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
        return true;
    }

    private void spawnParticles(ServerWorld world, double posX, double posY, double posZ) {
        for (int i = 0; i < 200; ++i) {
            GenericParticleData data = new GenericParticleData(ModParticleTypes.MOKU);
            data.setColor(0.48f, 0.36f, 0.0f);
            data.setLife(30);
            data.setSize(3.0f);
            data.setMotion(WyHelper.randomDouble() / 4.0, WyHelper.randomDouble(), WyHelper.randomDouble() / 4.0);
            double offsetX = WyHelper.randomWithRange(-3, 3) * WyHelper.randomDouble();
            double offsetY = WyHelper.randomWithRange(-2, 2) * WyHelper.randomDouble();
            double offsetZ = WyHelper.randomWithRange(-3, 3) * WyHelper.randomDouble();
            WyHelper.spawnParticles(data, world, posX + offsetX, posY + offsetY, posZ + offsetZ);
        }
    }
}

