/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.cyborg;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.projectiles.cyborg.RadicalBeamProjectile;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncEntityStatsPacket;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

public class RadicalBeamAbility
extends ChargeableAbility {
    public static final Ability INSTANCE = new RadicalBeamAbility();

    public RadicalBeamAbility() {
        super("Radical Beam", AbilityHelper.getRacialCategory());
        this.setMaxCooldown(22.0);
        this.setMaxChargeTime(3.0);
        this.setDescription("The user launches a powerful beam of energy at the opponent");
        this.onStartChargingEvent = this::onStartChargingEvent;
        this.duringChargingEvent = this::duringChargingEvent;
        this.onEndChargingEvent = this::onEndChargingEvent;
    }

    private void duringChargingEvent(PlayerEntity player, int i) {
        if (i == 39) {
            player.field_70170_p.func_217384_a(null, (Entity)player, ModSounds.PRE_CYBORG_BEAM_SFX, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
    }

    private boolean onStartChargingEvent(PlayerEntity player) {
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        if (props.getCola() - 50 < 0) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NOT_ENOUGH_COLA, new Object[0]));
            return false;
        }
        player.field_70170_p.func_217384_a(null, (Entity)player, ModSounds.CHARGE_CYBORG_BEAM_SFX, SoundCategory.PLAYERS, 1.0f, 1.0f);
        return true;
    }

    private boolean onEndChargingEvent(PlayerEntity player) {
        player.field_70170_p.func_217384_a(null, (Entity)player, ModSounds.CYBORG_BEAM_SFX, SoundCategory.PLAYERS, 1.0f, 1.0f);
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        RadicalBeamProjectile proj = new RadicalBeamProjectile(player.field_70170_p, (LivingEntity)player);
        player.field_70170_p.func_217376_c((Entity)proj);
        proj.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 3.75f, 1.0f);
        props.alterCola(-50);
        WyNetwork.sendTo(new SSyncEntityStatsPacket(player.func_145782_y(), props), player);
        return true;
    }
}

