/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.doa;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.DamagedContinuousAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModSounds;

public class AirDoorAbility
extends DamagedContinuousAbility {
    public static final AirDoorAbility INSTANCE = new AirDoorAbility();

    public AirDoorAbility() {
        super("Air Door", AbilityHelper.getDevilFruitCategory());
        this.setDescription("The user travels into an air dimension and is invincible during that time");
        this.setThreshold(60.0);
        this.onStartContinuityEvent = this::onStartContinuityEvent;
        this.onEndContinuityEvent = this::onEndContinuityEvent;
        this.onDamagedEvent = this::onDamaged;
    }

    private boolean onDamaged(LivingEntity entity, DamageSource damageSource, double amount) {
        return damageSource.func_151517_h();
    }

    private boolean onStartContinuityEvent(PlayerEntity player) {
        player.func_195064_c(new EffectInstance(Effects.field_76441_p, 1200, 0, false, false));
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), ModSounds.DOA_IN_SFX, SoundCategory.PLAYERS, 1.0f, 1.0f);
        return true;
    }

    private boolean onEndContinuityEvent(PlayerEntity player) {
        player.func_195063_d(Effects.field_76441_p);
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), ModSounds.DOA_OUT_SFX, SoundCategory.PLAYERS, 1.0f, 1.0f);
        double cooldown = 10.0f + (float)this.continueTime / 40.0f;
        this.setMaxCooldown(cooldown);
        return true;
    }
}

