/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.doctor;

import com.google.common.collect.Lists;
import java.util.Collection;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.PotionEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModArmors;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;

public class FailedExperimentAbility
extends ChargeableAbility {
    public static final Ability INSTANCE = new FailedExperimentAbility();

    public FailedExperimentAbility() {
        super("Failed Experiment", AbilityHelper.getStyleCategory());
        this.setMaxCooldown(7.0);
        this.setMaxChargeTime(2.0);
        this.setDescription("Throws a random splash potion with a debuff effect at the enemy");
        this.onEndChargingEvent = this::onEndChargingEvent;
    }

    private boolean onEndChargingEvent(PlayerEntity player) {
        boolean hasMedicBag;
        ItemStack medicBag = (ItemStack)player.field_71071_by.field_70460_b.get(2);
        boolean bl = hasMedicBag = medicBag != null && medicBag.func_77973_b() == ModArmors.MEDIC_BAG;
        if (!hasMedicBag) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_MEDIC_BAG, new Object[]{this.getName()}));
            return false;
        }
        PotionEntity potion = new PotionEntity(player.field_70170_p, (LivingEntity)player);
        int potionType = (int)WyHelper.randomWithRange(0, 3);
        ItemStack stack = new ItemStack((IItemProvider)Items.field_185155_bH);
        switch (potionType) {
            case 0: {
                stack = PotionUtils.func_185184_a((ItemStack)stack, (Collection)Lists.newArrayList((Object[])new EffectInstance[]{new EffectInstance(Effects.field_76431_k, 200, 1)}));
                break;
            }
            case 1: {
                stack = PotionUtils.func_185184_a((ItemStack)stack, (Collection)Lists.newArrayList((Object[])new EffectInstance[]{new EffectInstance(Effects.field_76419_f, 200, 1)}));
                break;
            }
            case 2: {
                stack = PotionUtils.func_185184_a((ItemStack)stack, (Collection)Lists.newArrayList((Object[])new EffectInstance[]{new EffectInstance(Effects.field_76436_u, 200, 1)}));
                break;
            }
            case 3: {
                stack = PotionUtils.func_185184_a((ItemStack)stack, (Collection)Lists.newArrayList((Object[])new EffectInstance[]{new EffectInstance(Effects.field_76438_s, 200, 1)}));
            }
        }
        potion.func_184541_a(stack);
        potion.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, -20.0f, 0.8f, 1.0f);
        player.field_70170_p.func_217376_c((Entity)potion);
        int damage = medicBag.func_77952_i() + 10 <= medicBag.func_77958_k() ? 10 : medicBag.func_77958_k() - medicBag.func_77952_i();
        medicBag.func_222118_a(damage, (LivingEntity)player, user -> user.func_213361_c(EquipmentSlotType.MAINHAND));
        if (medicBag.func_77952_i() >= medicBag.func_77958_k()) {
            medicBag.func_190918_g(1);
        }
        return true;
    }
}

