/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.doctor;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import xyz.pixelatedw.mineminenomi.api.events.LivingHealByEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModArmors;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.doctor.FirstAidParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.PunchAbility;

public class FirstAidAbility
extends PunchAbility {
    public static final FirstAidAbility INSTANCE = new FirstAidAbility();
    private static final ParticleEffect PARTICLES = new FirstAidParticleEffect();

    public FirstAidAbility() {
        super("First Aid", AbilityHelper.getStyleCategory());
        this.setMaxCooldown(10.0);
        this.setDescription("Allows the user to heal their target");
        this.onStartContinuityEvent = this::onStartContinuityEvent;
        this.onHitEntityEvent = this::onHitEntity;
    }

    private boolean onStartContinuityEvent(PlayerEntity player) {
        boolean hasMedicBag;
        ItemStack medicBag = (ItemStack)player.field_71071_by.field_70460_b.get(2);
        boolean bl = hasMedicBag = medicBag != null && medicBag.func_77973_b() == ModArmors.MEDIC_BAG;
        if (!hasMedicBag) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_MEDIC_BAG, new Object[]{this.getName()}));
            return false;
        }
        return true;
    }

    private float onHitEntity(PlayerEntity player, LivingEntity target) {
        boolean hasMedicBag;
        ItemStack medicBag = (ItemStack)player.field_71071_by.field_70460_b.get(2);
        boolean bl = hasMedicBag = medicBag != null && medicBag.func_77973_b() == ModArmors.MEDIC_BAG;
        if (!hasMedicBag) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_MEDIC_BAG, new Object[]{this.getName()}));
            return -1.0f;
        }
        int heal = (int)(8.0 + WyHelper.percentage(20.0, target.func_110138_aP()));
        LivingHealByEvent event = new LivingHealByEvent((LivingEntity)player, target, heal);
        MinecraftForge.EVENT_BUS.post((Event)event);
        target.func_70691_i((float)heal);
        PARTICLES.spawn(player.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), 0.0, 0.0, 0.0);
        int damage = medicBag.func_77952_i() + 10 <= medicBag.func_77958_k() ? 10 : medicBag.func_77958_k() - medicBag.func_77952_i();
        medicBag.func_222118_a(damage, (LivingEntity)player, user -> user.func_213361_c(EquipmentSlotType.MAINHAND));
        if (medicBag.func_77952_i() >= medicBag.func_77958_k()) {
            medicBag.func_190918_g(1);
        }
        return 0.0f;
    }
}

