/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.doku;

import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.entities.zoan.VenomDemonZoanInfo;
import xyz.pixelatedw.mineminenomi.particles.effects.doku.DokuGumoParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ContinuousAbility;

public class DokuGumoAbility
extends ContinuousAbility {
    public static final DokuGumoAbility INSTANCE = new DokuGumoAbility();
    private static final DokuGumoParticleEffect PARTICLES = new DokuGumoParticleEffect();

    public DokuGumoAbility() {
        super("Doku Gumo", AbilityHelper.getDevilFruitCategory());
        this.setMaxCooldown(30.0);
        this.setThreshold(20.0);
        this.setDescription("Creates a dense cloud of poisonous smoke, which moves along with the user and poisons and blinds everyone inside");
        this.duringContinuityEvent = this::duringContinuity;
    }

    private void duringContinuity(PlayerEntity player, int timer) {
        int power = 0;
        int duration = 100;
        int range = 8;
        boolean color = false;
        if (VenomDemonZoanInfo.INSTANCE.isActive((LivingEntity)player)) {
            color = true;
            power += 2;
            duration *= 2;
            range = (int)((double)range * 1.5);
        }
        List<LivingEntity> targets = WyHelper.getEntitiesNear(player.func_180425_c(), player.field_70170_p, (double)range, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), LivingEntity.class);
        targets.remove(player);
        player.func_195064_c(new EffectInstance(Effects.field_76436_u, 200, 1));
        for (LivingEntity enemy : targets) {
            if (!enemy.func_70644_a(Effects.field_76440_q)) {
                enemy.func_195064_c(new EffectInstance(Effects.field_76440_q, duration, power));
            }
            if (!enemy.func_70644_a(Effects.field_76436_u)) {
                enemy.func_195064_c(new EffectInstance(Effects.field_76436_u, duration, power + 1));
            }
            if (enemy.func_70644_a(Effects.field_76437_t)) continue;
            enemy.func_195064_c(new EffectInstance(Effects.field_76437_t, duration, power));
        }
        DokuGumoAbility.PARTICLES.venomDemon = color;
        PARTICLES.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
    }

    public void enableVenomDemoMode() {
        this.setCustomTexture("doku_gumo_venom");
    }

    public void disableVenomDemoMode() {
        this.setCustomTexture("");
    }
}

