/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.doku;

import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.BlockPos;
import xyz.pixelatedw.mineminenomi.abilities.doku.ChloroBallAbility;
import xyz.pixelatedw.mineminenomi.abilities.doku.DokuFuguAbility;
import xyz.pixelatedw.mineminenomi.abilities.doku.DokuGumoAbility;
import xyz.pixelatedw.mineminenomi.abilities.doku.HydraAbility;
import xyz.pixelatedw.mineminenomi.abilities.doku.VenomRoadAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.ZoanAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.entities.zoan.VenomDemonZoanInfo;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SUpdateEquippedAbilityPacket;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.doku.VenomDemonParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

public class VenomDemonAbility
extends ZoanAbility {
    public static final VenomDemonAbility INSTANCE = new VenomDemonAbility();
    private static final ParticleEffect PARTICLES = new VenomDemonParticleEffect();
    private static final BlockProtectionRule GRIEF_RULE = DefaultProtectionRules.AIR_FOLIAGE.addApprovedBlocks(ModBlocks.POISON, ModBlocks.DEMON_POISON);
    private static final AttributeModifier ATTACK_MODIFIER = new AttributeModifier(UUID.fromString("0847f786-0a5a-4e83-9ea6-f924c259a798"), "Attack Modifier", 8.0, AttributeModifier.Operation.ADDITION).func_111168_a(false);
    private static final AttributeModifier REACH_MODIFIER = new AttributeModifier(UUID.fromString("930fd8dc-5f0c-4daa-869c-d42d6166d3f1"), "Reach Modifier", 2.0, AttributeModifier.Operation.ADDITION).func_111168_a(false);
    private static final AttributeModifier SPEED_MODIFIER = new AttributeModifier(UUID.fromString("4e2e4824-f5e8-449f-a54b-7d0a5572c6a1"), "Speed Modifier", 0.05, AttributeModifier.Operation.ADDITION).func_111168_a(false);
    private static final AttributeModifier ATTACK_SPEED = new AttributeModifier(UUID.fromString("2880a753-352a-4e1c-bf4e-4e4e4649febe"), "Attack Speed Modifier", 0.15, AttributeModifier.Operation.ADDITION).func_111168_a(false);
    private static final AttributeModifier STEP_ASSIST = new AttributeModifier(UUID.fromString("2880a753-352a-4e1c-bf4e-4e4e4649febe"), "Step assist Modifier", 1.5, AttributeModifier.Operation.ADDITION).func_111168_a(false);
    private static final AttributeModifier JUMP_HEIGHT = new AttributeModifier(UUID.fromString("2880a753-352a-4e1c-bf4e-4e4e4649febe"), "Jump Height Modifier", 2.0, AttributeModifier.Operation.ADDITION).func_111168_a(false);

    public VenomDemonAbility() {
        super("Venom Demon", AbilityHelper.getDevilFruitCategory(), VenomDemonZoanInfo.INSTANCE);
        this.setDescription("The user coats themselves in layers of strong corrosive venom, becoming a Venom Demon and leaving a highly poisonous trail. Also enhances all Posion abilities");
        this.setMaxCooldown(100.0);
        this.setThreshold(60.0);
        this.addZoanModifier(PlayerEntity.REACH_DISTANCE, REACH_MODIFIER);
        this.addZoanModifier(ModAttributes.ATTACK_RANGE, REACH_MODIFIER);
        this.addZoanModifier(SharedMonsterAttributes.field_111264_e, ATTACK_MODIFIER);
        this.addZoanModifier(SharedMonsterAttributes.field_111263_d, SPEED_MODIFIER);
        this.addZoanModifier(SharedMonsterAttributes.field_188790_f, ATTACK_SPEED);
        this.addZoanModifier(ModAttributes.STEP_HEIGHT, STEP_ASSIST);
        this.addZoanModifier(ModAttributes.FALL_RESISTANCE, STEP_ASSIST);
        this.addZoanModifier(ModAttributes.JUMP_HEIGHT, JUMP_HEIGHT);
        this.onStartContinuityEvent = this::onStartContinuityEvent;
        this.duringContinuityEvent = this::duringContinuity;
        this.onEndContinuityEvent = this::onEndContinuityEvent;
    }

    @Override
    public boolean onStartContinuityEvent(PlayerEntity player) {
        VenomRoadAbility venomDemonAbility;
        DokuGumoAbility dokuGumoAbility;
        DokuFuguAbility dokuFuguAbility;
        ChloroBallAbility chloroBallAbility;
        if (!super.onStartContinuityEvent(player)) {
            return false;
        }
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)player);
        HydraAbility hydraAbility = abilityProps.getEquippedAbility(HydraAbility.INSTANCE);
        if (hydraAbility != null) {
            hydraAbility.enableVenomDemoMode();
            WyNetwork.sendToAllTrackingAndSelf(new SUpdateEquippedAbilityPacket(player, hydraAbility), (LivingEntity)player);
        }
        if ((chloroBallAbility = abilityProps.getEquippedAbility(ChloroBallAbility.INSTANCE)) != null) {
            chloroBallAbility.enableVenomDemoMode();
            WyNetwork.sendToAllTrackingAndSelf(new SUpdateEquippedAbilityPacket(player, chloroBallAbility), (LivingEntity)player);
        }
        if ((dokuFuguAbility = abilityProps.getEquippedAbility(DokuFuguAbility.INSTANCE)) != null) {
            dokuFuguAbility.enableVenomDemoMode();
            WyNetwork.sendToAllTrackingAndSelf(new SUpdateEquippedAbilityPacket(player, dokuFuguAbility), (LivingEntity)player);
        }
        if ((dokuGumoAbility = abilityProps.getEquippedAbility(DokuGumoAbility.INSTANCE)) != null) {
            dokuGumoAbility.enableVenomDemoMode();
            WyNetwork.sendToAllTrackingAndSelf(new SUpdateEquippedAbilityPacket(player, dokuGumoAbility), (LivingEntity)player);
        }
        if ((venomDemonAbility = abilityProps.getEquippedAbility(VenomRoadAbility.INSTANCE)) != null) {
            venomDemonAbility.enableVenomDemoMode();
            WyNetwork.sendToAllTrackingAndSelf(new SUpdateEquippedAbilityPacket(player, venomDemonAbility), (LivingEntity)player);
        }
        return true;
    }

    private void duringContinuity(PlayerEntity player, int timer) {
        player.func_195064_c(new EffectInstance(ModEffects.DOKU_GUARD, 2, 3, false, false));
        if (!AbilityHelper.isNearbyKairoseki(player)) {
            for (int x = -1; x < 1; ++x) {
                for (int z = -1; z < 1; ++z) {
                    BlockPos pos = new BlockPos(player.func_226277_ct_() + (double)x, player.func_226278_cu_(), player.func_226281_cx_() + (double)z);
                    if (!player.field_70170_p.func_180495_p(pos.func_177977_b()).func_200132_m()) continue;
                    AbilityHelper.placeBlockIfAllowed(player.field_70170_p, player.func_226277_ct_() + (double)x, player.func_226278_cu_(), player.func_226281_cx_() + (double)z, ModBlocks.DEMON_POISON, GRIEF_RULE);
                }
            }
        }
        PARTICLES.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
    }

    @Override
    public boolean onEndContinuityEvent(PlayerEntity player) {
        VenomRoadAbility venomDemonAbility;
        DokuGumoAbility dokuGumoAbility;
        DokuFuguAbility dokuFuguAbility;
        ChloroBallAbility chloroBallAbility;
        super.onEndContinuityEvent(player);
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)player);
        HydraAbility hydraAbility = abilityProps.getEquippedAbility(HydraAbility.INSTANCE);
        if (hydraAbility != null) {
            hydraAbility.disableVenomDemoMode();
            WyNetwork.sendToAllTrackingAndSelf(new SUpdateEquippedAbilityPacket(player, hydraAbility), (LivingEntity)player);
        }
        if ((chloroBallAbility = abilityProps.getEquippedAbility(ChloroBallAbility.INSTANCE)) != null) {
            chloroBallAbility.disableVenomDemoMode();
            WyNetwork.sendToAllTrackingAndSelf(new SUpdateEquippedAbilityPacket(player, chloroBallAbility), (LivingEntity)player);
        }
        if ((dokuFuguAbility = abilityProps.getEquippedAbility(DokuFuguAbility.INSTANCE)) != null) {
            dokuFuguAbility.disableVenomDemoMode();
            WyNetwork.sendToAllTrackingAndSelf(new SUpdateEquippedAbilityPacket(player, dokuFuguAbility), (LivingEntity)player);
        }
        if ((dokuGumoAbility = abilityProps.getEquippedAbility(DokuGumoAbility.INSTANCE)) != null) {
            dokuGumoAbility.disableVenomDemoMode();
            WyNetwork.sendToAllTrackingAndSelf(new SUpdateEquippedAbilityPacket(player, dokuGumoAbility), (LivingEntity)player);
        }
        if ((venomDemonAbility = abilityProps.getEquippedAbility(VenomRoadAbility.INSTANCE)) != null) {
            venomDemonAbility.disableVenomDemoMode();
            WyNetwork.sendToAllTrackingAndSelf(new SUpdateEquippedAbilityPacket(player, venomDemonAbility), (LivingEntity)player);
        }
        return true;
    }
}

