/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.electro;

import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.abilities.electro.SulongAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ContinuousAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.IChangeDamageSourceAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.IParallelContinuousAbility;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;

public class EleclawAbility
extends ContinuousAbility
implements IChangeDamageSourceAbility,
IParallelContinuousAbility {
    public static final EleclawAbility INSTANCE = new EleclawAbility();
    private static final AttributeModifier ATTACK_SPEED_MODIFIER = new AttributeModifier(UUID.fromString("1d78a133-8a0e-4b8f-8790-1360007d4741"), "Attack Speed Multiplier", 0.25, AttributeModifier.Operation.ADDITION).func_111168_a(false);
    private static final int MAX_USES = 9;
    public int uses = 9;

    public EleclawAbility() {
        super("Eleclaw", AbilityHelper.getRacialCategory());
        this.setMaxCooldown(10.0);
        this.setDescription("The user coats their hands and weapons with lightning, enabling the use of other electric skills and giving the chance to stun foes");
        this.onStartContinuityEvent = this::onStartContinuityEvent;
        this.duringContinuityEvent = this::duringContinuityEvent;
        this.onEndContinuityEvent = this::onEndContinuityEvent;
    }

    private boolean onStartContinuityEvent(PlayerEntity player) {
        if (6 >= player.func_71024_bL().func_75116_a() || DevilFruitCapability.get((LivingEntity)player).hasDevilFruit(ModAbilities.GOMU_GOMU_NO_MI)) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_BODY, new Object[0]));
            return false;
        }
        player.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111124_b(ATTACK_SPEED_MODIFIER);
        player.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111121_a(ATTACK_SPEED_MODIFIER);
        return true;
    }

    private void duringContinuityEvent(PlayerEntity player, int i) {
        if (6 >= player.func_71024_bL().func_75116_a() || DevilFruitCapability.get((LivingEntity)player).hasDevilFruit(ModAbilities.GOMU_GOMU_NO_MI)) {
            this.stopContinuity(player);
        }
        if (i > 100) {
            player.func_71020_j(0.05f);
        }
        if (this.uses <= 0) {
            this.stopContinuity(player);
            this.uses = 9;
        }
        if (AbilityHelper.isAffectedByWater((LivingEntity)player)) {
            player.func_70097_a(ModDamageSource.LIGHTNING_BOLT.getSource(), this.getElectricPower(player) * 2.0f);
            this.stopContinuity(player);
        }
    }

    private boolean onEndContinuityEvent(PlayerEntity player) {
        if (this.getContinueTime() > 400) {
            player.func_71020_j(5.0f);
        }
        this.uses = 9;
        SulongAbility sulongAbility = AbilityDataCapability.get((LivingEntity)player).getEquippedAbility(SulongAbility.INSTANCE);
        boolean sulongEnabled = sulongAbility != null && sulongAbility.isContinuous();
        this.setMaxCooldown(sulongEnabled ? 0.0 : 10.0);
        player.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111124_b(ATTACK_SPEED_MODIFIER);
        return true;
    }

    @Override
    public float damageToEntityWithSource(PlayerEntity player, LivingEntity target) {
        float strength = Math.min((float)player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e(), 50.0f);
        float electricityDamage = this.getElectricPower(player);
        float keptDamage = (0.25f + electricityDamage / 120.0f) * (1.0f - strength / 160.0f);
        if (target.field_70172_ad > 0 && target.field_70172_ad <= 5) {
            target.field_70172_ad = 0;
            target.field_70737_aN = 0;
        }
        float finalDamage = strength * keptDamage;
        return Math.min(finalDamage, electricityDamage);
    }

    @Override
    public DamageSource getSourceToUse(PlayerEntity player) {
        return ModDamageSource.LIGHTNING_BOLT.causeEntityDamageFromSource((Entity)player);
    }

    public void reduceUsage(PlayerEntity player, int number) {
        boolean sulongEnabled;
        SulongAbility sulongAbility = AbilityDataCapability.get((LivingEntity)player).getEquippedAbility(SulongAbility.INSTANCE);
        boolean bl = sulongEnabled = sulongAbility != null && sulongAbility.isContinuous();
        if (!sulongEnabled) {
            this.uses -= number;
        }
    }

    @Override
    public boolean cancelsOriginalDamage() {
        return false;
    }

    @Override
    public boolean isSourceChangeEnabled() {
        return this.isContinuous();
    }

    public float getElectricPower(PlayerEntity player) {
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)player);
        SulongAbility sulongAbility = abilityProps.getEquippedAbility(SulongAbility.INSTANCE);
        boolean isSulongActive = sulongAbility != null && sulongAbility.isContinuous();
        float currentElectricalDamage = Math.max(6.0f * this.getElectricPowerPercentage(player), 0.1f);
        return currentElectricalDamage * (float)(isSulongActive ? 2 : 1);
    }

    public float getElectricPowerPercentage(PlayerEntity player) {
        IEntityStats statsProps = EntityStatsCapability.get((LivingEntity)player);
        return Math.min((float)statsProps.getDoriki(), 5000.0f) / 5000.0f;
    }
}

