/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.electro;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.abilities.electro.EleclawAbility;
import xyz.pixelatedw.mineminenomi.abilities.electro.SulongAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.electro.ElectricalLunaProjectile;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.particles.effects.electro.ElectroChargingParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;

public class ElectricalLunaAbility
extends ChargeableAbility {
    public static final ElectricalLunaAbility INSTANCE = new ElectricalLunaAbility();
    private static final ElectroChargingParticleEffect PARTICLES = new ElectroChargingParticleEffect();
    private static final int COOLDOWN = 16;

    public ElectricalLunaAbility() {
        super("Electrical Luna", AbilityHelper.getRacialCategory());
        this.setMaxCooldown(16.0);
        this.setMaxChargeTime(3.0);
        this.setDescription("Discharges a lightning stream from the ground beneath the user");
        this.setInPool(AbilityPool.MINK_ELECTRO);
        this.onStartChargingEvent = this::onStartChargingEvent;
        this.duringChargingEvent = this::duringChargingEvent;
        this.onEndChargingEvent = this::onEndChargingEvent;
    }

    private void duringChargingEvent(PlayerEntity player, int i) {
        PARTICLES.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
    }

    private boolean onStartChargingEvent(PlayerEntity player) {
        boolean eleclawEnabled;
        EleclawAbility eleclawAbility = AbilityDataCapability.get((LivingEntity)player).getEquippedAbility(EleclawAbility.INSTANCE);
        boolean bl = eleclawEnabled = eleclawAbility != null && eleclawAbility.isContinuous();
        if (!AbilityHelper.canUseMomentumAbility(player)) {
            return false;
        }
        if (!eleclawEnabled) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_ELECLAW, new Object[0]));
            return false;
        }
        SulongAbility sulongAbility = AbilityDataCapability.get((LivingEntity)player).getEquippedAbility(SulongAbility.INSTANCE);
        boolean sulongEnabled = sulongAbility != null && sulongAbility.isContinuous();
        this.setMaxChargeTime(sulongEnabled ? 1.0 : 3.0);
        this.setMaxCooldown(sulongEnabled ? 8.0 : 16.0);
        return true;
    }

    private boolean onEndChargingEvent(PlayerEntity player) {
        boolean eleclawEnabled;
        EleclawAbility eleclawAbility = AbilityDataCapability.get((LivingEntity)player).getEquippedAbility(EleclawAbility.INSTANCE);
        boolean bl = eleclawEnabled = eleclawAbility != null && eleclawAbility.isContinuous();
        if (eleclawEnabled) {
            SulongAbility sulongAbility = AbilityDataCapability.get((LivingEntity)player).getEquippedAbility(SulongAbility.INSTANCE);
            boolean sulongEnabled = sulongAbility != null && sulongAbility.isContinuous();
            float damage = Math.min(eleclawAbility.getElectricPower(player) * 1.5f, 16.0f);
            int maxLife = (int)((float)(sulongEnabled ? 18 : 9) * eleclawAbility.getElectricPowerPercentage(player));
            ElectricalLunaProjectile proj = new ElectricalLunaProjectile(player.field_70170_p, (LivingEntity)player);
            proj.setDamage(damage);
            proj.setMaxLife(maxLife);
            player.field_70170_p.func_217376_c((Entity)proj);
            proj.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, sulongEnabled ? 3.0f : 2.0f, 1.0f);
            player.func_71020_j(2.0f);
            eleclawAbility.reduceUsage(player, 2);
        }
        return true;
    }
}

