/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.electro;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.abilities.electro.EleclawAbility;
import xyz.pixelatedw.mineminenomi.abilities.electro.SulongAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IMultiTargetAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;

public class ElectricalMissileAbility
extends Ability
implements IMultiTargetAbility {
    public static final ElectricalMissileAbility INSTANCE = new ElectricalMissileAbility();
    private static final int COOLDOWN = 10;
    private boolean used = false;

    public ElectricalMissileAbility() {
        super("Electrical Missile", AbilityHelper.getRacialCategory());
        this.setMaxCooldown(10.0);
        this.setDescription("The user dashes forward and rapidly electrifies the enemy");
        this.onUseEvent = this::onUseEvent;
        this.duringCooldownEvent = this::duringCooldown;
    }

    private boolean onUseEvent(PlayerEntity player) {
        boolean eleclawEnabled;
        this.used = false;
        EleclawAbility eleclawAbility = AbilityDataCapability.get((LivingEntity)player).getEquippedAbility(EleclawAbility.INSTANCE);
        boolean bl = eleclawEnabled = eleclawAbility != null && eleclawAbility.isContinuous();
        if (!eleclawEnabled) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_ELECLAW, new Object[0]));
            return false;
        }
        if (!AbilityHelper.canUseMomentumAbility(player)) {
            return false;
        }
        SulongAbility sulongAbility = AbilityDataCapability.get((LivingEntity)player).getEquippedAbility(SulongAbility.INSTANCE);
        boolean sulongEnabled = sulongAbility != null && sulongAbility.isContinuous();
        Vec3d speed = WyHelper.propulsion((LivingEntity)player, sulongEnabled ? 4.0 : 3.0, sulongEnabled ? 4.0 : 3.0);
        player.func_213293_j(speed.field_72450_a, 0.2, speed.field_72449_c);
        player.field_70133_I = true;
        ((ServerWorld)player.field_70170_p).func_72863_F().func_217216_a((Entity)player, (IPacket)new SAnimateHandPacket((Entity)player, 0));
        this.clearTargets();
        this.setMaxCooldown(sulongEnabled ? 4.0 : 10.0);
        return true;
    }

    private void duringCooldown(PlayerEntity player, int cooldownTimer) {
        boolean eleclawEnabled;
        EleclawAbility eleclawAbility = AbilityDataCapability.get((LivingEntity)player).getEquippedAbility(EleclawAbility.INSTANCE);
        boolean bl = eleclawEnabled = eleclawAbility != null && eleclawAbility.isContinuous();
        if (this.canDealDamage()) {
            float damage = 10.0f;
            List<LivingEntity> list = WyHelper.getEntitiesNear(player.func_180425_c(), player.field_70170_p, 1.6, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), LivingEntity.class);
            list.remove(player);
            this.used = true;
            for (LivingEntity entity : list) {
                if (!this.isTarget(entity) || !player.func_70685_l((Entity)entity)) continue;
                if (eleclawEnabled) {
                    damage += eleclawAbility.getElectricPower(player);
                }
                entity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), damage);
            }
        } else if (this.used && eleclawEnabled) {
            player.func_71020_j(2.0f);
            eleclawAbility.reduceUsage(player, 1);
            this.used = false;
        }
    }

    public boolean canDealDamage() {
        return this.cooldown > this.getMaxCooldown() * 0.9;
    }
}

