/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.gomu;

import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.gomu.GearSecondParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ContinuousAbility;

public class GearSecondAbility
extends ContinuousAbility {
    public static final GearSecondAbility INSTANCE = new GearSecondAbility();
    private static final AttributeModifier MODIFIER_MULTIPLIER = new AttributeModifier(UUID.fromString("a44a9644-369a-4e18-88d9-323727d3d85b"), "Gear Second Modifier", 1.8, AttributeModifier.Operation.MULTIPLY_BASE).func_111168_a(false);
    private static final AttributeModifier STRENGTH_MODIFIER = new AttributeModifier(UUID.fromString("a2337b58-7e6d-4361-a8ca-943feee4f906"), "Gear Attack Damage Multiplier", 4.0, AttributeModifier.Operation.ADDITION).func_111168_a(false);
    private static final AttributeModifier STEP_HEIGHT = new AttributeModifier(UUID.fromString("eab680cd-a6dc-438a-99d8-46f9eb53a950"), "Gear 2 Step Height", 1.0, AttributeModifier.Operation.ADDITION).func_111168_a(false);
    private static final ParticleEffect PARTICLES = new GearSecondParticleEffect();
    private boolean prevSprintValue = false;

    public GearSecondAbility() {
        super("Gear Second", AbilityHelper.getDevilFruitCategory());
        this.setThreshold(40.0);
        this.setDescription("By speding up their blood flow, the user gains strength, speed and mobility");
        this.onStartContinuityEvent = this::onStartContinuity;
        this.duringContinuityEvent = this::duringContinuity;
        this.onEndContinuityEvent = this::onEndContinuityEvent;
    }

    private boolean onStartContinuity(PlayerEntity player) {
        player.func_110148_a(ModAttributes.STEP_HEIGHT).func_111121_a(STEP_HEIGHT);
        player.func_110148_a(ModAttributes.JUMP_HEIGHT).func_111121_a(STEP_HEIGHT);
        player.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111121_a(STRENGTH_MODIFIER);
        player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(STRENGTH_MODIFIER);
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), ModSounds.GEAR_SECOND_SFX, SoundCategory.PLAYERS, 1.0f, 1.0f);
        this.prevSprintValue = player.func_70051_ag();
        return true;
    }

    private void duringContinuity(PlayerEntity player, int passiveTimer) {
        if (passiveTimer % 10 == 0) {
            PARTICLES.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
        if (player.func_70090_H()) {
            this.stopContinuity(player);
        }
        if (player.func_70051_ag()) {
            if (!this.prevSprintValue) {
                player.field_70170_p.func_184133_a(null, player.func_180425_c(), ModSounds.TELEPORT_SFX, SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
        } else {
            this.prevSprintValue = false;
            return;
        }
        float maxSpeed = 2.2f;
        Vec3d vec = player.func_70040_Z();
        if (player.field_70122_E) {
            player.func_213293_j(vec.field_72450_a * (double)maxSpeed, player.func_213322_ci().field_72448_b, vec.field_72449_c * (double)maxSpeed);
        } else {
            player.func_213293_j(vec.field_72450_a * (double)maxSpeed * 0.5, player.func_213322_ci().field_72448_b, vec.field_72449_c * (double)maxSpeed * 0.5);
        }
        this.prevSprintValue = player.func_70051_ag();
        player.field_70133_I = true;
    }

    private boolean onEndContinuityEvent(PlayerEntity player) {
        int cooldown = (int)Math.round((double)this.continueTime / 30.0);
        this.setMaxCooldown(cooldown);
        if (this.continueTime > this.getThreshold() / 4 && EntityStatsCapability.get((LivingEntity)player).getDoriki() < 4000) {
            player.func_195064_c(new EffectInstance(Effects.field_76438_s, 600, 3, true, true));
            player.func_195064_c(new EffectInstance(Effects.field_76421_d, 200, 1, true, true));
        }
        player.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(MODIFIER_MULTIPLIER);
        player.func_110148_a(ModAttributes.STEP_HEIGHT).func_111124_b(STEP_HEIGHT);
        player.func_110148_a(ModAttributes.JUMP_HEIGHT).func_111124_b(STEP_HEIGHT);
        player.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111124_b(STRENGTH_MODIFIER);
        player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111124_b(STRENGTH_MODIFIER);
        return true;
    }
}

