/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.goro;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.particles.effects.goro.KariParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;

public class KariAbility
extends ChargeableAbility {
    public static final Ability INSTANCE = new KariAbility();
    private static final KariParticleEffect PARTICLES = new KariParticleEffect(1);

    public KariAbility() {
        super("Kari", AbilityHelper.getDevilFruitCategory());
        this.setDescription("The user heats the air around them with lightning until it explodes with a thunder clap. \n\nThis can be used to avoid and neutralize projectiles.");
        this.setMaxCooldown(12.0);
        this.setMaxChargeTime(4.0);
        this.setCancelable();
        this.duringChargingEvent = this::duringChargingEvent;
        this.onEndChargingEvent = this::onEndChargingEvent;
    }

    private void duringChargingEvent(PlayerEntity player, int chargeTimer) {
        AbilityHelper.slowEntityFall((LivingEntity)player);
        if (chargeTimer % 2 == 0) {
            float percentage = 1.0f - (float)this.getChargeTime() / (float)this.getMaxChargeTime();
            PARTICLES.setRange((int)(6.0f + 10.0f * percentage));
            PARTICLES.setSize(2.0f + 3.0f * percentage);
            PARTICLES.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
    }

    private boolean onEndChargingEvent(PlayerEntity player) {
        float percentage = 1.0f - (float)this.getChargeTime() / (float)this.getMaxChargeTime();
        List<Entity> list = WyHelper.getEntitiesNear(player.func_180425_c(), player.field_70170_p, (double)(6.0f + 10.0f * percentage), FactionHelper.getOutsideGroupPredicate((LivingEntity)player), Entity.class);
        list.remove(player);
        for (Entity target : list) {
            if (target instanceof ThrowableEntity || target instanceof AbstractArrowEntity) {
                target.func_70106_y();
            }
            if (!(target instanceof LivingEntity)) continue;
            target.func_70097_a(ModDamageSource.LIGHTNING_BOLT.causeEntityDamageFromSource((Entity)player), 20.0f + 40.0f * percentage);
        }
        player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187752_dd, SoundCategory.WEATHER, 2.0f, 0.5f + player.func_70681_au().nextFloat() * 0.2f);
        this.setMaxCooldown(1.0f + percentage * ((float)this.getMaxChargeTime() / 20.0f - 1.0f));
        return true;
    }
}

