/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.goro;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.LightningEntity;
import xyz.pixelatedw.mineminenomi.init.ModArmors;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.RepeaterAbility;

public class SangoAbility
extends RepeaterAbility {
    public static final Ability INSTANCE = new SangoAbility();

    public SangoAbility() {
        super("Sango", AbilityHelper.getDevilFruitCategory());
        this.setMaxCooldown(8.0);
        this.setMaxRepeaterCount(8, 5);
        this.setDescription("Launches a massive charge of electricity from the hands");
        this.onUseEvent = this::onUseEvent;
        this.duringContinuityEvent = this::duringContinuityEvent;
        this.onEndContinuityEvent = this::onEndContinuityEvent;
    }

    private void duringContinuityEvent(PlayerEntity player, int i) {
        AbilityHelper.slowEntityFall((LivingEntity)player);
    }

    private boolean onUseEvent(PlayerEntity player) {
        boolean hasTomoeDrums = ((ItemStack)player.field_71071_by.field_70460_b.get(2)).func_77973_b() == ModArmors.TOMOE_DRUMS;
        int beamLength = 20;
        BlockRayTraceResult mop = WyHelper.rayTraceBlocks((Entity)player, beamLength * this.getMaxRepeaterCount());
        double beamDistance = Math.sqrt(player.func_70092_e(mop.func_216347_e().field_72450_a, mop.func_216347_e().field_72448_b, mop.func_216347_e().field_72449_c));
        ((ServerWorld)player.field_70170_p).func_72863_F().func_217216_a((Entity)player, (IPacket)new SAnimateHandPacket((Entity)player, 0));
        LightningEntity bolt = new LightningEntity((Entity)player, (float)beamLength + (float)beamDistance, 12.0f);
        bolt.setAliveTicks(12);
        bolt.setDamage(hasTomoeDrums ? 17.5f : 15.0f);
        bolt.setExplosion(3, true, hasTomoeDrums ? 0.0f : 0.5f, 40);
        bolt.setSize(hasTomoeDrums ? 0.15f : 0.1f);
        bolt.disableExplosionKnockback();
        bolt.setAngle(45);
        bolt.setBranches((int)(5.0 + beamDistance / 100.0));
        int segments = (int)(beamDistance * 0.5);
        bolt.setSegments((int)((double)segments + WyHelper.randomWithRange(-segments / 2, segments / 2)));
        player.field_70170_p.func_217376_c((Entity)bolt);
        return true;
    }

    private boolean onEndContinuityEvent(PlayerEntity player) {
        this.setMaxCooldown(this.getMaxRepeaterCount() - this.getRepeaterCount());
        return true;
    }
}

