/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.goro;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IFallDamageBlockingAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.LightningEntity;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.goro.GenericUseLightningEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;

public class SparkStepAbility
extends Ability
implements IFallDamageBlockingAbility {
    public static final Ability INSTANCE = new SparkStepAbility();
    private static final GenericUseLightningEffect PARTICLES = new GenericUseLightningEffect();
    private boolean hasFallDamage = true;
    private float airJumps = 0.0f;

    public SparkStepAbility() {
        super("Spark Step", AbilityHelper.getDevilFruitCategory());
        this.setMaxCooldown(0.5);
        this.setDescription("Instantly teleport the user to their desired location");
        this.onUseEvent = this::onUseEvent;
    }

    private boolean onUseEvent(PlayerEntity player) {
        double maxTeleportDistance;
        AbilityHelper.slowEntityFall((LivingEntity)player, 30);
        double maxDist = maxTeleportDistance = 256.0;
        if (player.func_225608_bj_()) {
            maxDist /= 4.0;
        }
        this.airJumps = player.field_70122_E ? 0.0f : (float)((double)this.airJumps + maxDist / maxTeleportDistance);
        RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)player, maxDist);
        double x = mop.func_216347_e().field_72450_a;
        double y = Math.min(mop.func_216347_e().field_72448_b, (double)player.field_70170_p.getMaxHeight() * 1.5) + 0.5;
        double z = mop.func_216347_e().field_72449_c;
        if (player.func_184187_bx() != null) {
            player.func_184210_p();
        }
        BlockPos blockPos = new BlockPos(x, y, z);
        if (!player.field_70170_p.func_175723_af().func_177746_a(blockPos)) {
            this.setMaxCooldown(1.0);
            return true;
        }
        PARTICLES.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
        PARTICLES.spawn(player.field_70170_p, x, y, z, 0.0, 0.0, 0.0);
        float teleportDistance = (float)Math.sqrt(player.func_70092_e(x, y, z));
        LightningEntity bolt = new LightningEntity((Entity)player, teleportDistance + 2.0f);
        bolt.setAliveTicks(10);
        bolt.setDamage(10.0f);
        bolt.setSize(teleportDistance > 25.0f ? 0.03f : 0.015f);
        bolt.setBranches((int)WyHelper.randomWithRange(3, 6));
        bolt.setSegments(teleportDistance > 25.0f ? 8 : 2);
        player.field_70170_p.func_217376_c((Entity)bolt);
        player.func_223102_j(x, y, z);
        double cooldownOffset = 192 - (!player.field_70122_E ? 24 : 0) - (player.field_70172_ad > 0 ? 32 : 0);
        double cooldown = Math.max(maxTeleportDistance / cooldownOffset * ((double)teleportDistance / maxTeleportDistance), 0.5);
        this.hasFallDamage = false;
        if (this.airJumps > 15.0f) {
            this.setMaxCooldown(5.0 + cooldown);
            this.airJumps = 0.0f;
        } else {
            this.setMaxCooldown(cooldown);
        }
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), ModSounds.LIGHTNING_TELEPORT, SoundCategory.PLAYERS, 1.0f, 1.0f);
        return true;
    }

    @Override
    public void resetFallDamage(LivingEntity player) {
        this.hasFallDamage = true;
        this.setMaxCooldown(0.0);
        this.startCooldown((PlayerEntity)player);
        this.airJumps = 0.0f;
    }

    @Override
    public boolean hasFallDamage() {
        return this.hasFallDamage;
    }
}

