/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.gura;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.gura.GekishinProjectile;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SUpdateEquippedAbilityPacket;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.gura.AirCrackParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;
import xyz.pixelatedw.mineminenomi.wypi.network.packets.server.SSyncAbilityDataPacket;

public class GekishinAbility
extends ChargeableAbility {
    public static final Ability INSTANCE = new GekishinAbility();
    private static final ParticleEffect PARTICLES = new AirCrackParticleEffect();
    private MODE activeMode = MODE.GEKISHIN;

    public GekishinAbility() {
        super("Gekishin", AbilityHelper.getDevilFruitCategory());
        this.setDescription("The user 'cracks' the air, launching vibrations which send blocks flying \n\n\u00a72SHIFT-USE\u00a7r: Switches between Gekishin and Kaishin mode");
        this.setMaxCooldown(22.0);
        this.setMaxChargeTime(3.0);
        this.setCancelable();
        this.onStartChargingEvent = this::onStartChargingEvent;
        this.duringChargingEvent = this::duringChargingEvent;
        this.onEndChargingEvent = this::onEndChargingEvent;
    }

    private boolean onStartChargingEvent(PlayerEntity player) {
        if (player.func_225608_bj_()) {
            if (this.activeMode == MODE.GEKISHIN) {
                this.activeMode = MODE.KAISHIN;
                this.setMaxCooldown(32.0);
                this.setMaxChargeTime(4.0);
                this.setCustomTexture("kaishin");
            } else {
                this.activeMode = MODE.GEKISHIN;
                this.setMaxCooldown(22.0);
                this.setMaxChargeTime(3.0);
                this.setCustomTexture("gekishin");
            }
            player.func_145747_a((ITextComponent)new TranslationTextComponent("Ability mode set to: " + (Object)((Object)this.activeMode), new Object[0]));
            IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
            WyNetwork.sendTo(new SSyncAbilityDataPacket(player.func_145782_y(), props), player);
            WyNetwork.sendToAllTrackingAndSelf(new SUpdateEquippedAbilityPacket(player, this), (LivingEntity)player);
            return false;
        }
        return true;
    }

    private void duringChargingEvent(PlayerEntity player, int i) {
        player.func_195064_c(new EffectInstance(ModEffects.MOVEMENT_BLOCKED, 4, 0, false, false));
    }

    private boolean onEndChargingEvent(PlayerEntity player) {
        float time = (float)this.getChargeTime() / (float)this.getMaxChargeTime();
        float multiplier = 1.0f - time;
        if ((double)multiplier < 0.2) {
            return false;
        }
        if (this.activeMode == MODE.GEKISHIN) {
            ((ServerWorld)player.field_70170_p).func_72863_F().func_217216_a((Entity)player, (IPacket)new SAnimateHandPacket((Entity)player, 0));
            EntityRayTraceResult trace = WyHelper.rayTraceEntities((Entity)player, 1.5);
            PARTICLES.spawn(player.field_70170_p, trace.func_216347_e().func_82615_a(), player.func_226278_cu_() + 0.5, trace.func_216347_e().func_82616_c(), 0.0, 0.0, 0.0);
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), ModSounds.GURA_SFX, SoundCategory.PLAYERS, 2.0f, 1.0f);
            GekishinProjectile proj = new GekishinProjectile(player.field_70170_p, (LivingEntity)player);
            proj.setMaxLife((int)((float)proj.getMaxLife() * multiplier));
            player.field_70170_p.func_217376_c((Entity)proj);
            proj.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 1.75f, 1.0f);
        } else {
            ((ServerWorld)player.field_70170_p).func_72863_F().func_217216_a((Entity)player, (IPacket)new SAnimateHandPacket((Entity)player, 0));
            ((ServerWorld)player.field_70170_p).func_72863_F().func_217216_a((Entity)player, (IPacket)new SAnimateHandPacket((Entity)player, 1));
            Vec3d v1 = player.func_213303_ch().func_72441_c(0.0, (double)player.func_70047_e(), 0.0).func_178787_e(player.func_70040_Z().func_186678_a(2.5).func_178785_b(180.0f));
            Vec3d v2 = player.func_213303_ch().func_72441_c(0.0, (double)player.func_70047_e(), 0.0).func_178787_e(player.func_70040_Z().func_186678_a(2.5).func_178785_b(-180.0f));
            PARTICLES.spawn(player.field_70170_p, v1.func_82615_a(), player.func_226278_cu_() + 0.5, v1.func_82616_c(), 0.0, 0.0, 0.0);
            PARTICLES.spawn(player.field_70170_p, v2.func_82615_a(), player.func_226278_cu_() + 0.5, v2.func_82616_c(), 0.0, 0.0, 0.0);
            List<Entity> list = WyHelper.getEntitiesNear(player.func_180425_c(), player.field_70170_p, (double)(10.0f * multiplier), FactionHelper.getOutsideGroupPredicate((LivingEntity)player), Entity.class);
            list.remove(player);
            for (Entity target : list) {
                if (target instanceof AbilityProjectileEntity && ((AbilityProjectileEntity)target).getDamage() < 40.0f * multiplier && ((AbilityProjectileEntity)target).isPhysical()) {
                    target.func_70106_y();
                }
                if (!(target instanceof LivingEntity)) continue;
                Vec3d speed = target.func_70676_i(1.0f).func_216372_d(3.0, 2.0, 3.0);
                target.func_213293_j(speed.field_72450_a, speed.field_72448_b, speed.field_72449_c);
                target.field_70133_I = true;
                target.field_70143_R = 0.0f;
            }
            player.field_70170_p.func_184133_a(null, player.func_180425_c(), ModSounds.GURA_SFX, SoundCategory.PLAYERS, 2.0f, 1.0f);
            GekishinProjectile p1 = new GekishinProjectile(player.field_70170_p, (LivingEntity)player);
            p1.setMaxLife((int)((float)p1.getMaxLife() * multiplier));
            player.field_70170_p.func_217376_c((Entity)p1);
            p1.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z + 90.0f, 0.0f, 1.75f, 1.0f);
            GekishinProjectile p2 = new GekishinProjectile(player.field_70170_p, (LivingEntity)player);
            p2.setMaxLife((int)((float)p2.getMaxLife() * multiplier));
            player.field_70170_p.func_217376_c((Entity)p2);
            p2.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z - 90.0f, 0.0f, 1.75f, 1.0f);
        }
        return true;
    }

    public static enum MODE {
        GEKISHIN,
        KAISHIN;

    }
}

