/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.gura;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.EntityRayTraceResult;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.common.BlockParticlesEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.gura.AirCrackParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;

public class TenchiMeidoAbility
extends ChargeableAbility {
    public static final Ability INSTANCE = new TenchiMeidoAbility();
    private static final ParticleEffect PARTICLES = new BlockParticlesEffect(20, 200);
    private static final ParticleEffect CHARGE_PARTICLES = new AirCrackParticleEffect();

    public TenchiMeidoAbility() {
        super("Tenchi Meido", AbilityHelper.getDevilFruitCategory());
        this.setMaxCooldown(20.0);
        this.setMaxChargeTime(1.0);
        this.setDescription("The user grabs the air and pulls it downwards, after which all of the opponents are tossed into the air");
        this.duringChargingEvent = this::duringChargingEvent;
        this.onEndChargingEvent = this::onEndChargingEvent;
    }

    private void duringChargingEvent(PlayerEntity player, int chargeTime) {
        if (chargeTime % 2 == 0) {
            PARTICLES.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
        player.func_195064_c(new EffectInstance(ModEffects.MOVEMENT_BLOCKED, 10, 0));
        player.func_213293_j(0.0, -0.2, 0.0);
        player.field_70133_I = true;
    }

    private boolean onEndChargingEvent(PlayerEntity player) {
        EntityRayTraceResult trace = WyHelper.rayTraceEntities((Entity)player, 1.5);
        CHARGE_PARTICLES.spawn(player.field_70170_p, trace.func_216347_e().func_82615_a(), player.func_226278_cu_() + 0.5, trace.func_216347_e().func_82616_c(), 0.0, 0.0, 0.0);
        List targets = WyHelper.getEntitiesNear(player.func_180425_c(), player.field_70170_p, 16.0, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), LivingEntity.class);
        targets.removeIf(entity -> !entity.field_70122_E);
        targets.remove(player);
        targets.stream().filter(target -> target != null && target.func_70089_S()).forEach(target -> {
            target.func_213293_j(0.0, 3.0, 0.0);
            target.field_70133_I = true;
        });
        return true;
    }
}

