/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.haki;

import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.abilities.haki.BusoshokuHakiHardeningAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool;
import xyz.pixelatedw.mineminenomi.api.abilities.IBodyOverlayAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IHakiAbility;
import xyz.pixelatedw.mineminenomi.api.enums.HakiType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ContinuousAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.IParallelContinuousAbility;

public class BusoshokuHakiFullBodyHardeningAbility
extends ContinuousAbility
implements IHakiAbility,
IParallelContinuousAbility,
IBodyOverlayAbility {
    public static final BusoshokuHakiFullBodyHardeningAbility INSTANCE = new BusoshokuHakiFullBodyHardeningAbility();
    private static final AbilityOverlay OVERLAY = new AbilityOverlay().setTexture(ModResources.BUSOSHOKU_HAKI_ARM).setColor(WyHelper.hexToRGB("#FFFFFFAA"));
    private final UUID armorUUID = UUID.fromString("0457f786-0a5a-4e83-9ea6-f924c259a798");
    private final UUID armorThougnessUUID = UUID.fromString("0457f786-0a5a-4e83-9ea6-f924c259a798");
    private final UUID strengthUUID = UUID.fromString("0457f786-0a5a-4e83-9ea4-f924c259a798");
    private final UUID damageReductionUUID = UUID.fromString("9121ac66-fb1c-48a7-a636-0cdc3f01d96e");
    private float damage;

    public BusoshokuHakiFullBodyHardeningAbility() {
        super("Busoshoku Haki: Full Body Hardening", AbilityHelper.getHakiCategory());
        this.setDescription("Covers the whole body of the user user in a layer of Armament haki, used for a balance between offense and defense");
        this.setInPool(AbilityPool.BUSOSHOKU_HAKI);
        this.onStartContinuityEvent = this::onStartContinuityEvent;
        this.duringContinuityEvent = this::duringContinuity;
        this.onEndContinuityEvent = this::onEndContinuityEvent;
    }

    private boolean onStartContinuityEvent(PlayerEntity player) {
        if (!HakiHelper.canUseHaki(player, this)) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_ONE_HAKI_TYPE, new Object[]{this.getName()}));
            return false;
        }
        if (!HakiHelper.canEnableHaki(player)) {
            return false;
        }
        IHakiData hakiProps = HakiDataCapability.get((LivingEntity)player);
        double defense = hakiProps.getBusoshokuHardeningHakiExp() / 5.0f;
        player.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111124_b(this.getEntryArmor(defense));
        player.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111121_a(this.getEntryArmor(defense));
        player.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111124_b(this.getEntryArmorThougness(defense / 4.0));
        player.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111121_a(this.getEntryArmorThougness(defense / 4.0));
        player.func_110148_a(ModAttributes.DAMAGE_REDUCTION).func_111124_b(this.getEntryDamageReduction((double)hakiProps.getBusoshokuHardeningHakiExp() * 0.0025));
        player.func_110148_a(ModAttributes.DAMAGE_REDUCTION).func_111121_a(this.getEntryDamageReduction((double)hakiProps.getBusoshokuHardeningHakiExp() * 0.0025));
        this.damage = BusoshokuHakiHardeningAbility.getPunchDamage(player) * 0.75f;
        player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111124_b(this.getEntryAttackDamage(this.damage));
        player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(this.getEntryAttackDamage(this.damage));
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), ModSounds.BUSOSHOKU_HAKI_SFX, SoundCategory.PLAYERS, 1.0f, 1.0f);
        return true;
    }

    private void duringContinuity(PlayerEntity player, int passiveTimer) {
        ItemStack heldItem;
        boolean isOnMaxOveruse = HakiHelper.checkForHakiOveruse(player, 1 + passiveTimer / 2400);
        if (isOnMaxOveruse) {
            this.stopContinuity(player);
        }
        if (!(heldItem = player.func_184614_ca()).func_190926_b()) {
            player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111124_b(this.getEntryAttackDamage(0.0));
        } else if (player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111127_a(this.strengthUUID) == null) {
            player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111121_a(this.getEntryAttackDamage(this.damage));
        }
    }

    private boolean onEndContinuityEvent(PlayerEntity player) {
        player.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111124_b(this.getEntryArmor(0.0));
        player.func_110148_a(SharedMonsterAttributes.field_189429_h).func_111124_b(this.getEntryArmorThougness(0.0));
        player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111124_b(this.getEntryAttackDamage(0.0));
        player.func_110148_a(ModAttributes.DAMAGE_REDUCTION).func_111124_b(this.getEntryDamageReduction(0.0));
        if (this.continueTime / 20 > 10) {
            HakiHelper.checkForHakiOveruse(player, 100);
        }
        int cooldown = (int)WyHelper.clamp(Math.round((double)this.continueTime / 30.0), 10L, 90L);
        this.setMaxCooldown(cooldown);
        return true;
    }

    private AttributeModifier getEntryArmor(double amount) {
        return new AttributeModifier(this.armorUUID, "Full body Haki Resitance", amount, AttributeModifier.Operation.ADDITION).func_111168_a(false);
    }

    private AttributeModifier getEntryArmorThougness(double amount) {
        return new AttributeModifier(this.armorThougnessUUID, "Full body Haki Resitance", amount, AttributeModifier.Operation.ADDITION).func_111168_a(false);
    }

    private AttributeModifier getEntryDamageReduction(double amount) {
        return new AttributeModifier(this.damageReductionUUID, "Full body Haki Damage Reduction", amount, AttributeModifier.Operation.ADDITION).func_111168_a(false);
    }

    private AttributeModifier getEntryAttackDamage(double amount) {
        return new AttributeModifier(this.strengthUUID, "Full Body Haki Strength Attack", amount, AttributeModifier.Operation.ADDITION).func_111168_a(false);
    }

    @Override
    public HakiType getType() {
        return HakiType.HARDENING;
    }

    @Override
    public AbilityOverlay getBodyOverlay() {
        return OVERLAY;
    }
}

