/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.haki;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.IHakiAbility;
import xyz.pixelatedw.mineminenomi.api.enums.HakiType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ContinuousAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.IParallelContinuousAbility;

public class BusoshokuHakiImbuingAbility
extends ContinuousAbility
implements IHakiAbility,
IParallelContinuousAbility {
    public static final BusoshokuHakiImbuingAbility INSTANCE = new BusoshokuHakiImbuingAbility();

    public BusoshokuHakiImbuingAbility() {
        super("Busoshoku Haki: Imbuing", AbilityHelper.getHakiCategory());
        this.setDescription("Covers the weapon of the user in Armament haki, making their weapon attacks stronger and being able to damage Logia users");
        this.onStartContinuityEvent = this::onStartContinuityEvent;
        this.duringContinuityEvent = this::duringContinuity;
        this.onEndContinuityEvent = this::onEndContinuityEvent;
    }

    @Override
    public void use(PlayerEntity player) {
        if (player.func_184614_ca().func_77973_b() == ModWeapons.ENMA && this.isContinuous()) {
            return;
        }
        super.use(player);
    }

    private boolean onStartContinuityEvent(PlayerEntity player) {
        if (!HakiHelper.canUseHaki(player, this)) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_ONE_HAKI_TYPE, new Object[]{this.getName()}));
            return false;
        }
        if (!HakiHelper.canEnableHaki(player)) {
            return false;
        }
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), ModSounds.BUSOSHOKU_HAKI_SFX, SoundCategory.PLAYERS, 1.0f, 1.0f);
        return true;
    }

    private void duringContinuity(PlayerEntity player, int passiveTimer) {
        boolean isOnMaxOveruse = HakiHelper.checkForHakiOveruse(player, passiveTimer / 5900);
        if (isOnMaxOveruse) {
            this.stopContinuity(player);
        }
    }

    private boolean onEndContinuityEvent(PlayerEntity player) {
        int cooldown = (int)WyHelper.clamp(Math.round((double)this.continueTime / 30.0), 10L, 60L);
        this.setMaxCooldown(cooldown);
        if (this.continueTime / 20 > 10) {
            HakiHelper.checkForHakiOveruse(player, 100);
        }
        return true;
    }

    @Override
    public HakiType getType() {
        return HakiType.IMBUING;
    }
}

