/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.haki;

import java.util.List;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.SoundCategory;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities.haki.BusoshokuHakiGoal;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.haki.HaoshokuHakiParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;

public class HaoshokuHakiAbility
extends ChargeableAbility {
    public static final HaoshokuHakiAbility INSTANCE = new HaoshokuHakiAbility();
    public static final ParticleEffect PARTICLES_1 = new HaoshokuHakiParticleEffect(1);
    public static final ParticleEffect PARTICLES_2 = new HaoshokuHakiParticleEffect(2);
    public static final ParticleEffect PARTICLES_3 = new HaoshokuHakiParticleEffect(3);

    public HaoshokuHakiAbility() {
        super("Haoshoku Haki", AbilityHelper.getHakiCategory());
        this.setDescription("A burst of the unique Conqueror's haki, that knocks out enemies that are weaker than the user");
        this.setMaxChargeTime(3.0);
        this.onEndChargingEvent = this::onEndChargingEvent;
    }

    private boolean onEndChargingEvent(PlayerEntity player) {
        IHakiData hakiProps = HakiDataCapability.get((LivingEntity)player);
        hakiProps.alterHakiOveruse(1200);
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), ModSounds.HAKI_RELEASE_SFX, SoundCategory.PLAYERS, 1.0f, 1.0f);
        float haoLevel = HakiHelper.getTotalHakiExp((LivingEntity)player) / 100.0f;
        int cooldown = 0;
        double radius = 0.0;
        int unconsciousTimer = 0;
        if (haoLevel < 1.0f) {
            radius = 10.0;
            unconsciousTimer = 0;
            cooldown = 120;
            PARTICLES_1.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
        } else if (haoLevel >= 1.0f && (double)haoLevel < 2.5) {
            radius = 25.0;
            unconsciousTimer = 100;
            cooldown = 60;
            PARTICLES_2.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
        } else if ((double)haoLevel >= 2.5) {
            radius = 40.0;
            unconsciousTimer = 200;
            cooldown = 60;
            PARTICLES_3.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
        List<LivingEntity> targets = WyHelper.getEntitiesNear(player.func_180425_c(), player.field_70170_p, radius, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), LivingEntity.class);
        targets.remove(player);
        for (LivingEntity target : targets) {
            if (unconsciousTimer > 0) {
                float dorikiConversion;
                float targetHaoLevel = 0.0f;
                if (target instanceof PlayerEntity) {
                    float hakiLevel = HakiHelper.getTotalHakiExp(target) / 100.0f;
                    dorikiConversion = (float)EntityStatsCapability.get(target).getDoriki() / 10000.0f;
                    targetHaoLevel = hakiLevel + dorikiConversion;
                } else if (target instanceof OPEntity) {
                    float busoHaki = ((OPEntity)target).field_70714_bg.func_220888_c().anyMatch(goal -> goal.func_220772_j() instanceof BusoshokuHakiGoal) ? 1.0f : 0.0f;
                    dorikiConversion = (float)((OPEntity)target).getDoriki() / 100.0f;
                    targetHaoLevel = busoHaki + dorikiConversion;
                }
                if ((double)targetHaoLevel + 0.5 >= (double)haoLevel) continue;
                EffectInstance instance = new EffectInstance(ModEffects.UNCONSCIOUS, unconsciousTimer, 1, false, false);
                target.func_195064_c(new EffectInstance(ModEffects.ABILITY_OFF, unconsciousTimer - 20, 0, false, false));
                target.func_195064_c(instance);
                ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SPlayEntityEffectPacket(target.func_145782_y(), instance));
                continue;
            }
            target.func_195064_c(new EffectInstance(Effects.field_76431_k, 100, 0));
        }
        this.setMaxCooldown(cooldown);
        return true;
    }
}

