/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.hie;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.hie.IceBlockAvalancheProjectile;
import xyz.pixelatedw.mineminenomi.particles.effects.hie.IceBlockAvalancheParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;

public class IceBlockAvalancheAbility
extends ChargeableAbility {
    public static final IceBlockAvalancheAbility INSTANCE = new IceBlockAvalancheAbility();
    private IceBlockAvalancheProjectile proj;
    private int dmg = 0;
    public static final IceBlockAvalancheParticleEffect PARTICLES = new IceBlockAvalancheParticleEffect();

    public IceBlockAvalancheAbility() {
        super("Ice Block: Avalanche", AbilityHelper.getDevilFruitCategory());
        this.setDescription("Makes a big ice ball drop onto the spot the user is aiming at");
        this.setMaxChargeTime(6.0);
        this.setMaxCooldown(9.0);
        this.onStartChargingEvent = this::onStartChargingEvent;
        this.duringChargingEvent = this::duringChargingEvent;
        this.onEndChargingEvent = this::onEndChargingEvent;
        this.setCancelable();
    }

    private boolean onStartChargingEvent(PlayerEntity player) {
        BlockRayTraceResult ray = WyHelper.rayTraceBlocks((Entity)player, 20.0);
        EntityRayTraceResult eray = WyHelper.rayTraceEntities((Entity)player, 50.0);
        this.removeDuplicate();
        this.proj = new IceBlockAvalancheProjectile(player.field_70170_p, (LivingEntity)player);
        if (eray.func_216348_a() != null) {
            this.proj.func_70107_b(eray.func_216348_a().func_226277_ct_(), eray.func_216348_a().func_226278_cu_() + 15.0, eray.func_216348_a().func_226281_cx_());
        } else {
            this.proj.func_70107_b(ray.func_216350_a().func_177958_n(), ray.func_216350_a().func_177956_o() + 15, ray.func_216350_a().func_177952_p());
        }
        this.proj.func_213293_j(0.0, 0.0, 0.0);
        player.field_70170_p.func_217376_c((Entity)this.proj);
        return true;
    }

    private void duringChargingEvent(PlayerEntity p, int ticks) {
        this.dmg = ticks;
        if (p != null && this.proj != null) {
            PARTICLES.spawn(p.field_70170_p, this.proj.func_226277_ct_(), this.proj.func_226278_cu_(), this.proj.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
    }

    private boolean onEndChargingEvent(PlayerEntity p) {
        if (this.proj == null) {
            return false;
        }
        this.proj.setFinalized(true);
        this.proj.setDamage((float)(this.getMaxChargeTime() - this.dmg) / 20.0f * 2.0f);
        this.proj.func_213293_j(0.0, -2.0, 0.0);
        return true;
    }

    private void removeDuplicate() {
        if (this.proj != null && this.proj.isAddedToWorld()) {
            this.proj.func_70106_y();
        }
    }
}

