/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.hiso;

import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;

public class ForewarnAbility
extends Ability {
    public static final ForewarnAbility INSTANCE = new ForewarnAbility();
    private static final List<Biome> OCEANS = Arrays.asList(Biomes.field_76771_b, Biomes.field_203616_V, Biomes.field_203619_Y, Biomes.field_203620_Z, Biomes.field_76776_l, Biomes.field_203618_X, Biomes.field_150575_M, Biomes.field_203617_W, Biomes.field_203614_T, Biomes.field_203615_U);

    public ForewarnAbility() {
        super("Animals Forwarning", AbilityHelper.getDevilFruitCategory());
        this.onUseEvent = this::onUseEvent;
        this.setMaxCooldown(30.0);
    }

    private boolean onUseEvent(PlayerEntity player) {
        List nearby = player.field_70170_p.func_217357_a(AnimalEntity.class, new AxisAlignedBB(player.func_180425_c().func_177982_a(-10, -10, -10), player.func_180425_c().func_177982_a(10, 10, 10)));
        if (nearby.size() > 0 && !player.field_70170_p.field_72995_K) {
            float speed = this.getSpeedFromConditions(player, player.field_70170_p.func_72820_D() + 1000L);
            player.func_145747_a((ITextComponent)new StringTextComponent("The wind speed in 1000 ticks here will be: " + speed));
            player.func_145747_a((ITextComponent)new StringTextComponent("Clear weather may next happen in " + player.field_70170_p.func_72912_H().func_176133_A() / 1200 + " minutes"));
            player.func_145747_a((ITextComponent)new StringTextComponent("Thunder may next happen in " + player.field_70170_p.func_72912_H().func_76071_n() / 1200 + " minutes"));
            player.func_145747_a((ITextComponent)new StringTextComponent("Rain may next happen in " + player.field_70170_p.func_72912_H().func_76083_p() / 1200 + " minutes"));
        }
        return true;
    }

    private float getSpeedFromConditions(PlayerEntity entity, long worldTime) {
        float x;
        int phase = (int)(worldTime / 24000L % 8L + 8L) % 8;
        int biomeid = OCEANS.indexOf(entity.field_70170_p.func_226691_t_(entity.func_180425_c()));
        int seedIn = phase * biomeid;
        for (x = (float)((seedIn + 53427321) * 13413431 % 142346134); x > 1.25f; x /= 2.0f) {
        }
        return ForewarnAbility.round(Math.abs(x), 2);
    }

    private static float round(float d, int decimalPlace) {
        String v = d + "";
        String[] l = v.split("\\.");
        if (l[1].length() >= decimalPlace) {
            l[1] = l[1].substring(0, decimalPlace);
            return Float.parseFloat(l[0] + "." + l[1]);
        }
        return Float.parseFloat(l[0] + "." + l[1]);
    }
}

