/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.ito;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.math.EntityRayTraceResult;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityPool;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ito.KumoNoSugakiParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ContinuousAbility;

public class KumoNoSugakiAbility
extends ContinuousAbility {
    public static final KumoNoSugakiAbility INSTANCE = new KumoNoSugakiAbility();
    private static final KumoNoSugakiParticleEffect PARTICLES = new KumoNoSugakiParticleEffect();

    public KumoNoSugakiAbility() {
        super("Kumo no Sugaki", AbilityHelper.getDevilFruitCategory());
        this.setThreshold(6.0);
        this.setDescription("Creates a huge web that protects the user from any attack");
        this.setInPool(AbilityPool.TEKKAI_LIKE);
        this.duringContinuityEvent = this::duringContinuity;
        this.onEndContinuityEvent = this::onEndContinuityEvent;
    }

    private void duringContinuity(PlayerEntity player, int passiveTimer) {
        EntityRayTraceResult trace = WyHelper.rayTraceEntities((Entity)player, 0.8);
        player.func_195064_c(new EffectInstance(ModEffects.GUARDING, 2, 5, false, false));
        if (passiveTimer % 2 == 0) {
            PARTICLES.spawn(player.field_70170_p, trace.func_216347_e().func_82615_a(), player.func_226278_cu_(), trace.func_216347_e().func_82616_c(), 0.0, 0.0, 0.0);
        }
    }

    private boolean onEndContinuityEvent(PlayerEntity player) {
        int cooldown = (int)Math.round((double)this.continueTime / 40.0) + 2;
        this.setMaxCooldown(cooldown);
        return true;
    }
}

