/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.ito;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import xyz.pixelatedw.mineminenomi.abilities.ito.TorikagoAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.entities.mobs.ability.BlackKnightEntity;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;

public class ParasiteAbility
extends Ability {
    public static final ParasiteAbility INSTANCE = new ParasiteAbility();

    public ParasiteAbility() {
        super("Parasite", AbilityHelper.getDevilFruitCategory());
        this.setDescription("By attaching your strings to nearby enemies, they get completely immobilized");
        this.setMaxCooldown(30.0);
        this.onUseEvent = this::onUseEvent;
    }

    private boolean onUseEvent(PlayerEntity player) {
        TorikagoAbility ability = AbilityDataCapability.get((LivingEntity)player).getEquippedAbility(TorikagoAbility.INSTANCE);
        if (ability != null && ability.isEntityInThisTorikago((Entity)player)) {
            List<LivingEntity> targets = WyHelper.getEntitiesNear(player.func_180425_c(), player.field_70170_p, 30.0, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), LivingEntity.class);
            targets.remove(player);
            for (LivingEntity target : targets) {
                if (target instanceof BlackKnightEntity || !AbilityHelper.isInsideTorikago((Entity)target)) continue;
                target.func_195064_c(new EffectInstance(Effects.field_76440_q, 300, 0, false, false));
                target.func_195064_c(new EffectInstance(ModEffects.MOVEMENT_BLOCKED, 300, 0, false, false));
            }
            this.setMaxCooldown(30.0);
        } else {
            EntityRayTraceResult trace = WyHelper.rayTraceEntities((Entity)player, 16.0);
            if (trace.func_216346_c().equals((Object)RayTraceResult.Type.ENTITY) && trace.func_216348_a() instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)trace.func_216348_a();
                if (!(target instanceof BlackKnightEntity)) {
                    target.func_195064_c(new EffectInstance(Effects.field_76440_q, 300, 0, false, false));
                    target.func_195064_c(new EffectInstance(ModEffects.MOVEMENT_BLOCKED, 300, 0, false, false));
                    this.setMaxCooldown(15.0);
                }
            } else {
                return false;
            }
        }
        return true;
    }
}

