/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.ito;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.AirBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.FoliageBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.LiquidBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.blocks.tileentities.TorikagoTileEntity;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SUpdateEquippedAbilityPacket;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ContinuousAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.IParallelContinuousAbility;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

public class TorikagoAbility
extends ContinuousAbility
implements IParallelContinuousAbility {
    public static final TorikagoAbility INSTANCE = new TorikagoAbility();
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule(AirBlockProtectionRule.INSTANCE, FoliageBlockProtectionRule.INSTANCE, LiquidBlockProtectionRule.INSTANCE).setBypassGriefRule();
    private List<BlockPos> blockList = new ArrayList<BlockPos>();
    private List<BlockPos> placedBlockList = new ArrayList<BlockPos>();
    public static final int MAX_CAGE_SIZE = 36;
    public static final int MAX_THRESHOLD = 3;
    public int roomSize = 0;
    private int chargingTicks = 0;

    public TorikagoAbility() {
        super("Torikago", AbilityHelper.getDevilFruitCategory());
        this.setMaxCooldown(20.0);
        this.setDescription("Creates an indestructible dome made of strings, that damage anyone who touches them");
        this.onStartContinuityEvent = this::onStartContinuityEvent;
        this.duringContinuityEvent = this::duringContinuityEvent;
        this.onEndContinuityEvent = this::onEndContinuityEvent;
    }

    private boolean onStartContinuityEvent(PlayerEntity player) {
        this.chargingTicks = 10;
        this.setThreshold(3.0);
        return player.func_71024_bL().func_75116_a() > 6;
    }

    private void duringContinuityEvent(PlayerEntity player, int continuousTime) {
        if (this.getThreshold() == 0) {
            if (this.blockList.isEmpty()) {
                this.blockList.addAll(AbilityHelper.createSphere(player.field_70170_p, player.func_180425_c(), this.roomSize, true, ModBlocks.STRING_WALL, 0, GRIEF_RULE));
                BlockPos center = new BlockPos(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
                player.field_70170_p.func_175656_a(center, ModBlocks.STRING_MID.func_176223_P());
                TileEntity te = player.field_70170_p.func_175625_s(center);
                if (te != null && te instanceof TorikagoTileEntity) {
                    ((TorikagoTileEntity)te).setOwner((LivingEntity)player);
                    ((TorikagoTileEntity)te).func_70296_d();
                }
                this.blockList.add(new BlockPos(MathHelper.func_76128_c((double)player.func_226277_ct_()), MathHelper.func_76128_c((double)player.func_226278_cu_()), MathHelper.func_76128_c((double)player.func_226281_cx_())));
                this.placedBlockList.addAll(this.blockList);
                this.setThreshold(0.0);
            } else {
                int placedBlocks = 0;
                Iterator<BlockPos> iter = this.placedBlockList.iterator();
                while (iter.hasNext()) {
                    BlockPos pos = iter.next();
                    player.field_70170_p.func_184138_a(pos, Blocks.field_150350_a.func_176223_P(), ModBlocks.STRING_WALL.func_176223_P(), 0);
                    iter.remove();
                    if (++placedBlocks <= 500) continue;
                    return;
                }
            }
            player.func_71020_j(0.005f * ((float)this.roomSize / 30.0f));
            if (player.func_71024_bL().func_75116_a() < 6) {
                this.stopContinuity(player);
            }
        } else {
            this.chargingTicks = 0 >= this.chargingTicks ? 19 : --this.chargingTicks;
        }
    }

    private boolean onEndContinuityEvent(PlayerEntity player) {
        if (this.getThreshold() > 0) {
            this.setThreshold(0.0);
            WyNetwork.sendToAllTrackingAndSelf(new SUpdateEquippedAbilityPacket(player, this), (LivingEntity)player);
            this.roomSize = (int)(12.0f + 24.0f * ((float)this.continueTime / 60.0f));
            return false;
        }
        for (BlockPos pos : this.blockList) {
            Block currentBlock = player.field_70170_p.func_180495_p(pos).func_177230_c();
            if (currentBlock != ModBlocks.STRING_WALL && currentBlock != ModBlocks.STRING_MID) continue;
            player.field_70170_p.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        }
        this.blockList.clear();
        this.placedBlockList.clear();
        this.setMaxCooldown(10.0f * ((float)this.roomSize / 30.0f));
        return true;
    }

    public boolean isEntityInThisTorikago(Entity entity) {
        int roomSize = this.roomSize;
        for (int i = -roomSize; i < roomSize; ++i) {
            for (int j = -roomSize; j < roomSize; ++j) {
                for (int k = -roomSize; k < roomSize; ++k) {
                    double distance;
                    if (entity.field_70170_p.func_180495_p(new BlockPos(entity.func_226277_ct_() + (double)i, entity.func_226278_cu_() + (double)j, entity.func_226281_cx_() + (double)k)).func_177230_c() != ModBlocks.STRING_MID || !((distance = entity.func_70092_e(entity.func_226277_ct_() + (double)i, entity.func_226278_cu_() + (double)j, entity.func_226281_cx_() + (double)k)) < (double)((roomSize - 1) * (roomSize - 1)))) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

