/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.kage;

import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.mobs.ability.DoppelmanEntity;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ContinuousAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.IParallelContinuousAbility;

public class DoppelmanAbility
extends ContinuousAbility
implements IParallelContinuousAbility {
    public static final DoppelmanAbility INSTANCE = new DoppelmanAbility();
    private DoppelmanEntity doppelman = null;

    public DoppelmanAbility() {
        super("Doppelman", AbilityHelper.getDevilFruitCategory());
        this.setDescription("Creates a living version of the user's shadow to help them fight\n\n\u00a72SHIFT-USE\u00a7r: Switches between AGGRESSIVE and DEFENSIVE modes");
        this.setMaxCooldown(20.0);
        this.onStartContinuityEvent = this::onStartContinuityEvent;
        this.onEndContinuityEvent = this::onEndContinuityEvent;
    }

    private boolean onStartContinuityEvent(PlayerEntity player) {
        this.doppelman = new DoppelmanEntity(player.field_70170_p);
        this.doppelman.func_70080_a(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), player.field_70177_z, player.field_70125_A);
        this.doppelman.setOwner(player.func_110124_au());
        player.field_70170_p.func_217376_c((Entity)this.doppelman);
        return true;
    }

    private boolean onEndContinuityEvent(PlayerEntity player) {
        if (this.doppelman != null) {
            if (player.field_70122_E && player.func_225608_bj_()) {
                this.doppelman.isAggressive = !this.doppelman.isAggressive;
                String abilityName = new TranslationTextComponent(this.getI18nKey(), new Object[0]).func_150254_d();
                String puppetState = new TranslationTextComponent(this.doppelman.isAggressive ? ModI18n.ABILITY_PUPPET_STATE_AGGRESSIVE : ModI18n.ABILITY_PUPPET_STATE_DEFENSIVE, new Object[0]).func_150254_d();
                player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_PUPPET_STATE, new Object[]{abilityName, puppetState}));
                return false;
            }
            this.doppelman.func_70106_y();
        }
        int cooldown = (int)Math.round((double)this.continueTime / 50.0);
        this.setMaxCooldown(cooldown);
        return true;
    }

    public DoppelmanEntity getDoppelman() {
        return this.doppelman;
    }
}

