/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.kira;

import java.awt.Color;
import java.util.UUID;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.IBodyOverlayAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ContinuousAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.IParallelContinuousAbility;

public class DiamondBodyAbility
extends ContinuousAbility
implements IParallelContinuousAbility,
IBodyOverlayAbility {
    public static final DiamondBodyAbility INSTANCE = new DiamondBodyAbility();
    private static final AttributeModifier ARMOR_MODIFIER = new AttributeModifier(UUID.fromString("0847f786-0a5a-4e83-9ea6-f924c259a798"), "Diamond Body Armor Modifier", 24.0, AttributeModifier.Operation.ADDITION).func_111168_a(false);
    private static final AttributeModifier ARMOR_THOUGHNESS_MODIFIER = new AttributeModifier(UUID.fromString("a647e093-70f1-4369-86c4-7736718ef26c"), "Diamond Body Armor Thoughness Modifier", 12.0, AttributeModifier.Operation.ADDITION).func_111168_a(false);
    private static final AttributeModifier ATTACK_MODIFIER = new AttributeModifier(UUID.fromString("d6ee4b3f-92dd-4b55-9bb5-3c8b1100e438"), "Diamond Body Attack Modifier", 6.0, AttributeModifier.Operation.ADDITION).func_111168_a(false);
    private static final AbilityOverlay OVERLAY = new AbilityOverlay().setTexture(ModResources.DIAMOND_BODY).setColor(new Color(255, 255, 255, 165));

    public DiamondBodyAbility() {
        super("Diamond Body", AbilityHelper.getDevilFruitCategory());
        this.setThreshold(120.0);
        this.setDescription("Allows the user's body to become diamond, gaining high strength and defence");
        this.onStartContinuityEvent = this::onStartContinuityEvent;
        this.duringContinuityEvent = this::duringContinuity;
        this.onEndContinuityEvent = this::onEndContinuityEvent;
    }

    private boolean onStartContinuityEvent(PlayerEntity player) {
        return true;
    }

    private void duringContinuity(PlayerEntity player, int passiveTimer) {
        IAttributeInstance attribu;
        IAttributeInstance attrib;
        IAttributeInstance attri = player.func_110148_a(SharedMonsterAttributes.field_188791_g);
        if (!attri.func_180374_a(ARMOR_MODIFIER)) {
            attri.func_111121_a(ARMOR_MODIFIER);
        }
        if (!(attrib = player.func_110148_a(SharedMonsterAttributes.field_189429_h)).func_180374_a(ARMOR_THOUGHNESS_MODIFIER)) {
            attrib.func_111121_a(ARMOR_THOUGHNESS_MODIFIER);
        }
        if (!(attribu = player.func_110148_a(SharedMonsterAttributes.field_111264_e)).func_180374_a(ATTACK_MODIFIER)) {
            attribu.func_111121_a(ATTACK_MODIFIER);
        }
    }

    private boolean onEndContinuityEvent(PlayerEntity player) {
        IAttributeInstance attribu;
        IAttributeInstance attrib;
        IAttributeInstance attri = player.func_110148_a(SharedMonsterAttributes.field_188791_g);
        if (attri.func_180374_a(ARMOR_MODIFIER)) {
            attri.func_111124_b(ARMOR_MODIFIER);
        }
        if ((attrib = player.func_110148_a(SharedMonsterAttributes.field_189429_h)).func_180374_a(ARMOR_THOUGHNESS_MODIFIER)) {
            attrib.func_111124_b(ARMOR_THOUGHNESS_MODIFIER);
        }
        if ((attribu = player.func_110148_a(SharedMonsterAttributes.field_111264_e)).func_180374_a(ATTACK_MODIFIER)) {
            attribu.func_111124_b(ATTACK_MODIFIER);
        }
        int cooldown = (int)Math.round((double)this.continueTime / 60.0);
        this.setMaxCooldown(cooldown);
        return true;
    }

    @Override
    public AbilityOverlay getBodyOverlay() {
        return OVERLAY;
    }
}

