/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.kuku;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.IMultiTargetAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.CoreBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.FoliageBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.baku.BakuMunchParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;

public class GourmetSnipeAbility
extends Ability
implements IMultiTargetAbility {
    public static final GourmetSnipeAbility INSTANCE = new GourmetSnipeAbility();
    private static final ParticleEffect PARTICLES = new BakuMunchParticleEffect();
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule(CoreBlockProtectionRule.INSTANCE, FoliageBlockProtectionRule.INSTANCE);
    private static final ArrayList<Item> FOODS = new ArrayList<Item>(Arrays.asList(Items.field_222070_lD, Items.field_151077_bg, Items.field_179559_bp, Items.field_196102_ba, Items.field_151034_e, Items.field_179557_bn, Items.field_196104_bb, Items.field_226638_pX_, Items.field_151157_am));
    private int initialY;

    public GourmetSnipeAbility() {
        super("Gourmet Snipe", AbilityHelper.getDevilFruitCategory());
        this.setDescription("Launches the user forward and converts everything cut into food");
        this.setMaxCooldown(20.0);
        this.onUseEvent = this::onUseEvent;
        this.duringCooldownEvent = this::duringCooldown;
    }

    private boolean onUseEvent(PlayerEntity player) {
        if (!AbilityHelper.canUseMomentumAbility(player)) {
            return false;
        }
        if (!AbilityHelper.canUseSwordsmanAbilities((LivingEntity)player)) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_SWORD, new Object[0]));
            return false;
        }
        this.clearTargets();
        this.initialY = (int)player.func_226278_cu_();
        return true;
    }

    private void duringCooldown(PlayerEntity player, int cooldownTimer) {
        if (this.canDealDamage() && player.func_226278_cu_() >= (double)this.initialY) {
            Vec3d speed = WyHelper.propulsion((LivingEntity)player, 1.6, 1.6);
            player.func_213293_j(speed.field_72450_a, player.func_213322_ci().func_82617_b(), speed.field_72449_c);
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket((Entity)player));
            List<LivingEntity> list = WyHelper.getEntitiesNear(player.func_180425_c(), player.field_70170_p, 1.6, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), LivingEntity.class);
            list.remove(player);
            list.forEach(entity -> {
                if (this.isTarget((LivingEntity)entity)) {
                    entity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), 10.0f);
                }
            });
            for (BlockPos location : WyHelper.getNearbyBlocks((LivingEntity)player, 2)) {
                if (!((double)location.func_177956_o() >= player.func_226278_cu_()) || !AbilityHelper.placeBlockIfAllowed(player.field_70170_p, location.func_177958_n(), location.func_177956_o(), location.func_177952_p(), Blocks.field_150350_a, GRIEF_RULE)) continue;
                if (player.field_70170_p.field_73012_v.nextDouble() > 0.4) {
                    player.field_70170_p.func_217376_c((Entity)new ItemEntity(player.field_70170_p, (double)location.func_177958_n(), (double)location.func_177956_o(), (double)location.func_177952_p(), new ItemStack((IItemProvider)FOODS.get((int)WyHelper.randomWithRange(0, FOODS.size() - 1)))));
                }
                PARTICLES.spawn(player.field_70170_p, location.func_177958_n(), location.func_177956_o(), location.func_177952_p(), 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean canDealDamage() {
        return this.cooldown > this.getMaxCooldown() * 0.95;
    }
}

