/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.magu;

import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.CoreBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.FoliageBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.OreBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;

public class BakuretsuKazanAbility
extends ChargeableAbility {
    public static final Ability INSTANCE = new BakuretsuKazanAbility();
    public static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule(CoreBlockProtectionRule.INSTANCE, OreBlockProtectionRule.INSTANCE, FoliageBlockProtectionRule.INSTANCE);

    public BakuretsuKazanAbility() {
        super("Bakuretsu Kazan", AbilityHelper.getDevilFruitCategory());
        this.setMaxCooldown(25.0);
        this.setMaxChargeTime(5.0);
        this.setCancelable();
        this.setDescription("By spreading magma to the surroundings, the user turns everything into lava");
        this.onEndChargingEvent = this::endChargingEvent;
    }

    private boolean endChargingEvent(PlayerEntity player) {
        float time = (float)this.getChargeTime() / (float)this.getMaxChargeTime();
        float multiplier = 1.0f - time;
        int range = (int)(16.0f * multiplier);
        if (range < 5) {
            return false;
        }
        AbilityHelper.createFilledSphere(player.field_70170_p, (int)player.func_226277_ct_(), (int)player.func_226278_cu_(), (int)player.func_226281_cx_(), range, Blocks.field_150353_l, GRIEF_RULE);
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), ModSounds.MAGU_SFX, SoundCategory.PLAYERS, 1.0f, 1.0f);
        this.setCooldown((int)(this.getMaxCooldown() / 20.0 * (double)multiplier));
        return true;
    }
}

