/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.mera;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import xyz.pixelatedw.mineminenomi.api.abilities.IMultiTargetAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.mera.HeatDashParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.events.SetOnFireEvent;

public class HeatDashAbility
extends Ability
implements IMultiTargetAbility {
    public static final HeatDashAbility INSTANCE = new HeatDashAbility();
    private static final ParticleEffect PARTICLES = new HeatDashParticleEffect();

    public HeatDashAbility() {
        super("Heat Dash", AbilityHelper.getDevilFruitCategory());
        this.setMaxCooldown(7.0);
        this.setDescription("Transforms the user into fire and launches them forward");
        this.onUseEvent = this::onUseEvent;
        this.duringCooldownEvent = this::duringCooldown;
    }

    private boolean onUseEvent(PlayerEntity player) {
        if (!AbilityHelper.canUseMomentumAbility(player)) {
            return false;
        }
        this.clearTargets();
        player.field_70170_p.func_217384_a(null, (Entity)player, ModSounds.MERA_SFX, SoundCategory.PLAYERS, 2.0f, 2.0f);
        Vec3d speed = WyHelper.propulsion((LivingEntity)player, 3.0, 3.0, 3.0);
        player.func_213293_j(speed.field_72450_a, 0.5 + speed.field_72448_b, speed.field_72449_c);
        ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket((Entity)player));
        return true;
    }

    private void duringCooldown(PlayerEntity player, int cooldownTimer) {
        if (this.canDealDamage()) {
            Vec3d speed = WyHelper.propulsion((LivingEntity)player, 3.0, 3.0, 3.0);
            player.func_213293_j(speed.field_72450_a, speed.field_72448_b, speed.field_72449_c);
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket((Entity)player));
            if (cooldownTimer % 2 == 0) {
                PARTICLES.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
            List<LivingEntity> list = WyHelper.getEntitiesNear(player.func_180425_c(), player.field_70170_p, 1.4, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), LivingEntity.class);
            list.remove(player);
            for (LivingEntity target : list) {
                SetOnFireEvent event;
                if (!this.isTarget(target) || !player.func_70685_l((Entity)target) || MinecraftForge.EVENT_BUS.post((Event)(event = new SetOnFireEvent((LivingEntity)player, target, 2)))) continue;
                target.func_70015_d(2);
            }
        }
    }

    public boolean canDealDamage() {
        return this.cooldown > this.getMaxCooldown() * 0.9;
    }
}

