/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.mera;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import xyz.pixelatedw.mineminenomi.api.abilities.IMultiTargetAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.mera.HibashiraParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ContinuousAbility;

public class HibashiraAbility
extends ContinuousAbility
implements IMultiTargetAbility {
    public static final HibashiraAbility INSTANCE = new HibashiraAbility();
    private static final HibashiraParticleEffect PARTICLES = new HibashiraParticleEffect();

    public HibashiraAbility() {
        super("Hibashira", AbilityHelper.getDevilFruitCategory());
        this.setThreshold(5.0);
        this.setDescription("Creates a fire pillar extending both upwards and downwards, burning every enemy within it");
        this.onStartContinuityEvent = this::onStartContinuityEvent;
        this.duringContinuityEvent = this::duringContinuityEvent;
        this.onEndContinuityEvent = this::onEndContinuityEvent;
    }

    private boolean onStartContinuityEvent(PlayerEntity player) {
        this.clearTargets();
        return true;
    }

    private void duringContinuityEvent(PlayerEntity player, int continuousTime) {
        PARTICLES.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
        AbilityHelper.slowEntityFall((LivingEntity)player);
        List<Entity> list = WyHelper.getEntitiesNearSphere(player.func_180425_c(), player.field_70170_p, 3.0, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), Entity.class);
        for (int i = -10; i <= 10; ++i) {
            WyHelper.getEntitiesNearSphere(player.func_180425_c().func_177981_b(i), player.field_70170_p, 3.0, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), Entity.class).stream().filter(entity -> !list.contains(entity)).forEach(list::add);
        }
        list.remove(player);
        list.forEach(entity -> {
            boolean causedDamage = entity.func_70097_a(ModDamageSource.FIRE.causeEntityDamageFromSource((Entity)player), 5.0f);
            if (causedDamage && this.isTarget((LivingEntity)entity)) {
                entity.func_70015_d(4);
            }
        });
        if (continuousTime % 20 == 0) {
            this.clearTargets();
        }
        player.func_195064_c(new EffectInstance(ModEffects.MOVEMENT_BLOCKED, 5, 1, false, false));
    }

    private boolean onEndContinuityEvent(PlayerEntity player) {
        this.setMaxCooldown((float)Math.round((float)this.continueTime * 1.2f) / 20.0f);
        return true;
    }
}

