/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.mero;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.EntityRayTraceResult;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.mero.SlaveArrowProjectile;
import xyz.pixelatedw.mineminenomi.particles.effects.mero.SlaveArrowParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;

public class SlaveArrowAbility
extends ChargeableAbility {
    public static final SlaveArrowAbility INSTANCE = new SlaveArrowAbility();
    private static final SlaveArrowParticleEffect PARTICLES = new SlaveArrowParticleEffect();
    private int limit = 0;

    public SlaveArrowAbility() {
        super("Slave Arrow", AbilityHelper.getDevilFruitCategory());
        this.setMaxCooldown(13.0);
        this.setMaxChargeTime(7.0);
        this.setDescription("Creates a big heart from which the user shoots multiple love arrows, petrifying enemies");
        this.duringChargingEvent = this::duringChargingEvent;
        this.onEndChargingEvent = this::onEndChargingEvent;
        this.duringCooldownEvent = this::duringCooldownEvent;
    }

    private void duringCooldownEvent(PlayerEntity player, int cooldown) {
        int projectileSpace = 1;
        if (this.limit > 0 && (this.cooldown - 10.0) % 2.0 == 0.0) {
            SlaveArrowProjectile proj = new SlaveArrowProjectile(player.field_70170_p, (LivingEntity)player);
            proj.func_70012_b(player.func_226277_ct_() + WyHelper.randomWithRange(-projectileSpace, projectileSpace) + WyHelper.randomDouble(), player.func_226278_cu_() + 0.3 + WyHelper.randomWithRange(0, projectileSpace) + WyHelper.randomDouble(), player.func_226281_cx_() + WyHelper.randomWithRange(-projectileSpace, projectileSpace) + WyHelper.randomDouble(), 0.0f, 0.0f);
            player.field_70170_p.func_217376_c((Entity)proj);
            proj.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 3.0f, 4.0f);
            --this.limit;
        }
    }

    private void duringChargingEvent(PlayerEntity player, int chargeTime) {
        if (chargeTime > this.getMaxChargeTime() / 2) {
            PARTICLES.setSize(PARTICLES.getSize() + 0.2f);
        } else if (chargeTime <= this.getMaxChargeTime() / 2) {
            PARTICLES.setSize(PARTICLES.getSize() - 0.05f);
        }
        EntityRayTraceResult trace = WyHelper.rayTraceEntities((Entity)player, 0.8);
        if (chargeTime % 2 == 0) {
            PARTICLES.spawn(player.field_70170_p, trace.func_216347_e().func_82615_a(), player.func_226278_cu_(), trace.func_216347_e().func_82616_c(), 0.0, 0.0, 0.0);
        }
        player.func_195064_c(new EffectInstance(Effects.field_76421_d, 10, 2000));
        player.func_213293_j(0.0, 0.0, 0.0);
        player.field_70133_I = true;
    }

    private boolean onEndChargingEvent(PlayerEntity player) {
        this.limit = 20;
        PARTICLES.setSize(5.0f);
        return true;
    }
}

