/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.mogu;

import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.abilities.mogu.MoguHeavyPointAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IFallDamageBlockingAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IMultiTargetAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.api.protection.DefaultProtectionRules;
import xyz.pixelatedw.mineminenomi.entities.zoan.MoguHeavyZoanInfo;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.baku.BakuMunchParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;

public class MoguraTonpoAbility
extends Ability
implements IMultiTargetAbility,
IFallDamageBlockingAbility {
    public static final MoguraTonpoAbility INSTANCE = new MoguraTonpoAbility();
    private static final ParticleEffect PARTICLES = new BakuMunchParticleEffect();
    private int initialY;
    private boolean hasFallDamage = true;

    public MoguraTonpoAbility() {
        super("Mogura Tonpo", AbilityHelper.getDevilFruitCategory());
        this.setDescription("Digs a massive tunnel forwards while in mole form\n\n\u00a72SHIFT-USE\u00a7r: Digs a tunnel straight below the user");
        this.setMaxCooldown(12.0);
        this.onUseEvent = this::onUseEvent;
        this.duringCooldownEvent = this::duringCooldown;
    }

    private boolean onUseEvent(PlayerEntity player) {
        if (!MoguHeavyZoanInfo.INSTANCE.isActive((LivingEntity)player)) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NOT_ZOAN_FORM_SINGLE, new Object[]{this.getName(), MoguHeavyPointAbility.INSTANCE.getName()}));
            return false;
        }
        this.clearTargets();
        this.initialY = (int)player.func_226278_cu_();
        if (player.func_225608_bj_()) {
            this.hasFallDamage = false;
            for (int x = -1; x < 1; ++x) {
                for (int y = 0; y < 10; ++y) {
                    for (int z = -1; z < 1; ++z) {
                        int posX = (int)player.func_226277_ct_() + x;
                        int posY = (int)player.func_226278_cu_() - y;
                        int posZ = (int)player.func_226281_cx_() + z;
                        BlockPos pos = new BlockPos(posX, posY, posZ);
                        player.func_195064_c(new EffectInstance(Effects.field_76429_m, 50, 4, false, false));
                        player.func_195064_c(new EffectInstance(Effects.field_76422_e, 400, 2, false, false));
                        BlockState tempBlock = player.field_70170_p.func_180495_p(pos);
                        if (!AbilityHelper.placeBlockIfAllowed(player.field_70170_p, posX, posY, posZ, Blocks.field_150350_a, DefaultProtectionRules.CORE_FOLIAGE_ORE)) continue;
                        player.field_71071_by.func_70441_a(new ItemStack((IItemProvider)tempBlock.func_177230_c()));
                        PARTICLES.spawn(player.field_70170_p, posX, posY, posZ, 0.0, 0.0, 0.0);
                    }
                }
            }
        } else {
            Vec3d speed = WyHelper.propulsion((LivingEntity)player, 4.0, 4.0);
            player.func_213293_j(speed.field_72450_a, 0.3, speed.field_72449_c);
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket((Entity)player));
        }
        return true;
    }

    private void duringCooldown(PlayerEntity player, int cooldownTimer) {
        if (this.canDealDamage() && player.func_226278_cu_() >= (double)this.initialY) {
            List<LivingEntity> list = WyHelper.getEntitiesNear(player.func_180425_c(), player.field_70170_p, 1.6, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), LivingEntity.class);
            list.remove(player);
            list.forEach(entity -> {
                if (this.isTarget((LivingEntity)entity)) {
                    entity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), 15.0f);
                }
            });
            for (BlockPos location : WyHelper.getNearbyBlocks((LivingEntity)player, 3)) {
                if (!((double)location.func_177956_o() >= player.func_226278_cu_())) continue;
                BlockState tempBlock = player.field_70170_p.func_180495_p(new BlockPos(location.func_177958_n(), location.func_177956_o(), location.func_177952_p()));
                if (!AbilityHelper.placeBlockIfAllowed(player.field_70170_p, location.func_177958_n(), location.func_177956_o(), location.func_177952_p(), Blocks.field_150350_a, DefaultProtectionRules.CORE_FOLIAGE_ORE)) continue;
                player.field_71071_by.func_70441_a(new ItemStack((IItemProvider)tempBlock.func_177230_c()));
                PARTICLES.spawn(player.field_70170_p, location.func_177958_n(), location.func_177956_o(), location.func_177952_p(), 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean canDealDamage() {
        return this.cooldown > this.getMaxCooldown() * 0.8;
    }

    @Override
    public void resetFallDamage(LivingEntity player) {
        this.hasFallDamage = true;
    }

    @Override
    public boolean hasFallDamage() {
        return this.hasFallDamage;
    }
}

