/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.moku;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.network.play.server.SPlayerAbilitiesPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import xyz.pixelatedw.mineminenomi.api.abilities.IMultiTargetAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.moku.WhiteLauncherParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;

public class WhiteLauncherAbility
extends Ability
implements IMultiTargetAbility {
    public static final Ability INSTANCE = new WhiteLauncherAbility();
    private static final ParticleEffect PARTICLES = new WhiteLauncherParticleEffect();

    public WhiteLauncherAbility() {
        super("White Launcher", AbilityHelper.getDevilFruitCategory());
        this.setMaxCooldown(7.0);
        this.setDescription("Transforms the user into smoke and launches them forward");
        this.onUseEvent = this::onUseEvent;
        this.duringCooldownEvent = this::duringCooldown;
    }

    private boolean onUseEvent(PlayerEntity player) {
        if (!AbilityHelper.canUseMomentumAbility(player)) {
            return false;
        }
        player.field_71075_bZ.field_75101_c = false;
        player.field_71075_bZ.field_75100_b = false;
        ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SPlayerAbilitiesPacket(player.field_71075_bZ));
        this.clearTargets();
        Vec3d speed = WyHelper.propulsion((LivingEntity)player, 5.5, 5.5);
        player.func_213293_j(speed.field_72450_a, 2.0, speed.field_72449_c);
        ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket((Entity)player));
        return true;
    }

    private void duringCooldown(PlayerEntity player, int cooldownTimer) {
        if ((double)(cooldownTimer / 20) > this.maxCooldown / 20.0 - 3.0) {
            if (cooldownTimer % 2 == 0) {
                PARTICLES.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
            List<LivingEntity> list = WyHelper.getEntitiesNear(player.func_180425_c(), player.field_70170_p, 1.6, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), LivingEntity.class);
            list.remove(player);
            for (LivingEntity target : list) {
                if (!this.isTarget(target) || !player.func_70685_l((Entity)target)) continue;
                target.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), 15.0f);
            }
        }
    }
}

