/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.nagi;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.sound.PlaySoundEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ContinuousAbility;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;

public class SilentAbility
extends ContinuousAbility {
    public static final SilentAbility INSTANCE = new SilentAbility();

    public SilentAbility() {
        super("Silent", AbilityHelper.getDevilFruitCategory());
        this.setDescription("Cancels all noises caused by or around the user");
    }

    @Mod.EventBusSubscriber(modid="mineminenomi", value={Dist.CLIENT})
    public static class SilentAbilityClientEvents {
        @SubscribeEvent
        public static void onSoundPlayed(PlaySoundEvent event) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71441_e == null) {
                return;
            }
            BlockPos soundPos = new BlockPos((double)event.getSound().func_147649_g(), (double)event.getSound().func_147654_h(), (double)event.getSound().func_147651_i());
            List<PlayerEntity> players = WyHelper.getEntitiesNear(soundPos, (World)mc.field_71441_e, 30.0, PlayerEntity.class);
            if (players.size() <= 0) {
                return;
            }
            PlayerEntity user = null;
            PlayerEntity soundSource = null;
            for (PlayerEntity player : players) {
                if (player.func_180425_c().equals((Object)soundPos)) {
                    soundSource = player;
                    break;
                }
                if (!player.func_180425_c().func_218141_a((Vec3i)soundPos, 1.5)) continue;
                soundSource = player;
            }
            for (PlayerEntity player : players) {
                IDevilFruit props = DevilFruitCapability.get((LivingEntity)player);
                if (!props.hasDevilFruit(ModAbilities.NAGI_NAGI_NO_MI)) continue;
                user = player;
                break;
            }
            if (user == null || soundSource != user) {
                return;
            }
            IAbilityData abilityData = AbilityDataCapability.get(user);
            SilentAbility ability = abilityData.getEquippedAbility(INSTANCE);
            boolean isActive = ability != null && ability.isContinuous();
            double distFromNagi = user.func_70032_d((Entity)mc.field_71439_g);
            if (isActive && distFromNagi < 30.0) {
                event.setResultSound(null);
            }
        }
    }

    @Mod.EventBusSubscriber(modid="mineminenomi")
    public static class SilentAbilityServerEvents {
        @SubscribeEvent
        public static void onServerMessage(ServerChatEvent event) {
            IAbilityData abilityData;
            SilentAbility ability;
            ServerPlayerEntity player = event.getPlayer();
            IDevilFruit props = DevilFruitCapability.get((LivingEntity)player);
            if (props.hasDevilFruit(ModAbilities.NAGI_NAGI_NO_MI) && (ability = (abilityData = AbilityDataCapability.get((LivingEntity)player)).getEquippedAbility(INSTANCE)) != null && ability.isContinuous()) {
                event.setCanceled(true);
                List<PlayerEntity> players = WyHelper.getEntitiesNear(player.func_180425_c(), player.field_70170_p, 30.0, PlayerEntity.class);
                if (players.size() <= 0) {
                    return;
                }
                for (PlayerEntity target : players) {
                    target.func_145747_a(event.getComponent());
                }
            }
        }
    }
}

