/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.ope;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.abilities.ope.RoomAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IMultiTargetAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;

public class InjectionShotAbility
extends ChargeableAbility
implements IMultiTargetAbility {
    public static final Ability INSTANCE = new InjectionShotAbility();

    public InjectionShotAbility() {
        super("Injection Shot", AbilityHelper.getDevilFruitCategory());
        this.setMaxCooldown(10.0);
        this.setMaxChargeTime(1.0);
        this.setDescription("While holding a weapon, the user charges at the enemy, leaving confused");
        this.onStartChargingEvent = this::onStartChargingEvent;
        this.duringChargingEvent = this::duringChargingEvent;
        this.onEndChargingEvent = this::onEndChargingEvent;
        this.duringCooldownEvent = this::duringCooldown;
    }

    private boolean onStartChargingEvent(PlayerEntity player) {
        if (!AbilityHelper.canUseMomentumAbility(player)) {
            return false;
        }
        return this.canUseAbility(player);
    }

    private void duringChargingEvent(PlayerEntity player, int i) {
        if (!this.canUseAbility(player)) {
            this.startCooldown(player);
        }
        player.func_195064_c(new EffectInstance(ModEffects.MOVEMENT_BLOCKED, 2, 1, false, false));
    }

    private boolean onEndChargingEvent(PlayerEntity player) {
        if (!this.canUseAbility(player)) {
            return false;
        }
        this.clearTargets();
        Vec3d speed = WyHelper.propulsion((LivingEntity)player, 3.0, 3.0);
        player.func_213293_j(speed.field_72450_a, 0.2, speed.field_72449_c);
        ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket((Entity)player));
        return true;
    }

    private void duringCooldown(PlayerEntity player, int cooldownTimer) {
        if (this.canDealDamage()) {
            List<LivingEntity> list = WyHelper.getEntitiesNear(player.func_180425_c(), player.field_70170_p, 1.6, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), LivingEntity.class);
            list.remove(player);
            list.forEach(entity -> {
                if (this.isTarget((LivingEntity)entity)) {
                    entity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), 30.0f);
                    entity.func_195064_c(new EffectInstance(Effects.field_76431_k, 60, 0));
                }
            });
        }
    }

    private boolean canUseAbility(PlayerEntity player) {
        RoomAbility ability = AbilityDataCapability.get((LivingEntity)player).getEquippedAbility(RoomAbility.INSTANCE);
        if (ability == null || !ability.isEntityInThisRoom((Entity)player)) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_ONLY_IN_ROOM, new Object[]{this.getName()}));
            return false;
        }
        if (!ItemsHelper.isSword(player.func_184614_ca())) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_SWORD, new Object[0]));
            return false;
        }
        return true;
    }

    public boolean canDealDamage() {
        return this.cooldown > this.getMaxCooldown() * 0.8;
    }
}

