/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.ope;

import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.abilities.ope.RoomAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.items.HeartItem;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.IParallelContinuousAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.PunchAbility;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;

public class MesAbility
extends PunchAbility
implements IParallelContinuousAbility {
    public static final Ability INSTANCE = new MesAbility();

    public MesAbility() {
        super("MES", AbilityHelper.getDevilFruitCategory());
        this.setMaxCooldown(30.0);
        this.setDescription("Removes the heart of the user's target which they can then damage to hurt the opponent");
        this.onStartContinuityEvent = this::onStartContinuityEvent;
        this.duringContinuityEvent = this::duringContinuityEvent;
        this.onHitEntityEvent = this::onHitEntity;
    }

    private boolean onStartContinuityEvent(PlayerEntity player) {
        RoomAbility ability = AbilityDataCapability.get((LivingEntity)player).getEquippedAbility(RoomAbility.INSTANCE);
        if (ability == null || !ability.isEntityInThisRoom((Entity)player)) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_ONLY_IN_ROOM, new Object[]{this.getName()}));
            return false;
        }
        return true;
    }

    private void duringContinuityEvent(PlayerEntity player, int i) {
        RoomAbility ability = AbilityDataCapability.get((LivingEntity)player).getEquippedAbility(RoomAbility.INSTANCE);
        if (ability == null || !ability.isEntityInThisRoom((Entity)player)) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_ONLY_IN_ROOM, new Object[]{this.getName()}));
            this.stopContinuity(player);
        }
    }

    private float onHitEntity(PlayerEntity player, LivingEntity target) {
        boolean targetNoHeart;
        IDevilFruit props = DevilFruitCapability.get(target);
        IEntityStats targetProps = EntityStatsCapability.get(target);
        if (props.hasDevilFruit(ModAbilities.WARA_WARA_NO_MI)) {
            for (int i = 0; i < ((PlayerEntity)target).field_71071_by.field_70462_a.size(); ++i) {
                if (((PlayerEntity)target).field_71071_by.func_70301_a(i).func_77973_b() != ModItems.STRAW_DOLL) continue;
                return 0.0f;
            }
        }
        boolean bl = targetNoHeart = props.hasDevilFruit(ModAbilities.YOMI_YOMI_NO_MI) || target.func_70668_bt().equals(CreatureAttribute.field_223223_b_);
        if (!targetNoHeart) {
            targetNoHeart = AbilityHelper.isTargetBlockingAbility(player, target);
        }
        if (targetProps.hasHeart() && !targetNoHeart) {
            ItemStack heart = new ItemStack((IItemProvider)ModItems.HEART);
            ((HeartItem)heart.func_77973_b()).setHeartOwner(heart, target);
            heart.func_200302_a((ITextComponent)new StringTextComponent(target.func_145748_c_().func_150254_d() + "'s Heart"));
            player.field_71071_by.func_70441_a(heart);
            targetProps.setHeart(false);
        }
        return 1.0f;
    }
}

