/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.ope;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.abilities.ope.RoomAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.CoreBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.FoliageBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.LightningEntity;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SUpdateEquippedAbilityPacket;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.common.BlockParticlesEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

public class ShamblesAbility
extends ChargeableAbility {
    public static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule(CoreBlockProtectionRule.INSTANCE, FoliageBlockProtectionRule.INSTANCE);
    private static final ParticleEffect PARTICLES = new BlockParticlesEffect(2, 120);
    public static final Ability INSTANCE = new ShamblesAbility();

    public ShamblesAbility() {
        super("Shambles", AbilityHelper.getDevilFruitCategory());
        this.setMaxCooldown(5.0);
        this.setMaxChargeTime(1.0);
        this.setDescription("The user swaps place with the closest entity or block within the ROOM");
        this.onStartChargingEvent = this::onStartChargingEvent;
        this.duringChargingEvent = this::duringChargingEvent;
        this.onEndChargingEvent = this::onEndChargingEvent;
    }

    private boolean onStartChargingEvent(PlayerEntity player) {
        RoomAbility ability = AbilityDataCapability.get((LivingEntity)player).getEquippedAbility(RoomAbility.INSTANCE);
        if (ability == null || !ability.isEntityInThisRoom((Entity)player)) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_ONLY_IN_ROOM, new Object[]{this.getName()}));
            return false;
        }
        return true;
    }

    private void duringChargingEvent(PlayerEntity player, int i) {
        RoomAbility ability = AbilityDataCapability.get((LivingEntity)player).getEquippedAbility(RoomAbility.INSTANCE);
        if (ability == null || !ability.isEntityInThisRoom((Entity)player) || !AbilityHelper.canUseMomentumAbility(player)) {
            this.startCooldown(player);
        }
        if (!player.func_225608_bj_()) {
            RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)player, 64.0);
            if (i % 2 == 0) {
                PARTICLES.spawn(player.field_70170_p, mop.func_216347_e().field_72450_a, mop.func_216347_e().field_72448_b, mop.func_216347_e().field_72449_c, 0.0, 0.0, 0.0);
            }
        }
    }

    private boolean onEndChargingEvent(PlayerEntity player) {
        if (!AbilityHelper.canUseMomentumAbility(player)) {
            return false;
        }
        RoomAbility ability = AbilityDataCapability.get((LivingEntity)player).getEquippedAbility(RoomAbility.INSTANCE);
        if (ability == null) {
            return false;
        }
        if (!ability.isEntityInThisRoom((Entity)player)) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_ONLY_IN_ROOM, new Object[]{this.getName()}));
            return false;
        }
        if (player.func_225608_bj_()) {
            List list = WyHelper.getEntitiesNear(player.func_180425_c(), player.field_70170_p, 32.0, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), LivingEntity.class);
            list.removeIf(entity -> !ability.isEntityInThisRoom((Entity)entity));
            list.remove(player);
            if (list.size() <= 0) {
                return true;
            }
            LivingEntity target = (LivingEntity)list.get(0);
            if ((double)HakiHelper.getTotalHakiExp((LivingEntity)player) <= (double)HakiHelper.getTotalHakiExp(target) + WyHelper.randomWithRange(-3, 2)) {
                return true;
            }
            float[] beforeCoords = new float[]{(float)player.func_226277_ct_(), (float)player.func_226278_cu_(), (float)player.func_226281_cx_(), player.field_70177_z, player.field_70125_A};
            player.func_70080_a(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), target.field_70177_z, target.field_70125_A);
            player.func_70634_a(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
            target.func_70080_a((double)beforeCoords[0], (double)beforeCoords[1], (double)beforeCoords[2], beforeCoords[3], beforeCoords[4]);
        } else {
            RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)player, 64.0);
            if (mop instanceof EntityRayTraceResult) {
                EntityRayTraceResult entityRayTraceResult = (EntityRayTraceResult)mop;
                if (entityRayTraceResult.func_216348_a() instanceof LightningEntity || entityRayTraceResult.func_216348_a() instanceof AbilityProjectileEntity && !((AbilityProjectileEntity)entityRayTraceResult.func_216348_a()).isPhysical()) {
                    return true;
                }
                if (entityRayTraceResult.func_216348_a() instanceof LivingEntity) {
                    LivingEntity target = (LivingEntity)((EntityRayTraceResult)mop).func_216348_a();
                    if (!ability.isEntityInThisRoom((Entity)target)) {
                        return true;
                    }
                    if ((double)HakiHelper.getTotalHakiExp((LivingEntity)player) <= (double)HakiHelper.getTotalHakiExp(target) + WyHelper.randomWithRange(-2, 2)) {
                        return true;
                    }
                    float[] beforeCoords = new float[]{(float)player.func_226277_ct_(), (float)player.func_226278_cu_(), (float)player.func_226281_cx_(), player.field_70177_z, player.field_70125_A};
                    player.field_70170_p.func_184133_a(null, player.func_180425_c(), ModSounds.TELEPORT_SFX, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    player.field_70170_p.func_184133_a(null, target.func_180425_c(), ModSounds.TELEPORT_SFX, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    player.func_70080_a(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), target.field_70177_z, target.field_70125_A);
                    player.func_70634_a(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
                    target.func_70080_a((double)beforeCoords[0], (double)beforeCoords[1], (double)beforeCoords[2], beforeCoords[3], beforeCoords[4]);
                } else {
                    Entity target = ((EntityRayTraceResult)mop).func_216348_a();
                    if (!ability.isEntityInThisRoom(target)) {
                        return true;
                    }
                    float[] beforeCoords = new float[]{(float)player.func_226277_ct_(), (float)player.func_226278_cu_(), (float)player.func_226281_cx_(), player.field_70177_z, player.field_70125_A};
                    player.func_70080_a(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), target.field_70177_z, target.field_70125_A);
                    player.func_70634_a(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
                    target.func_70080_a((double)beforeCoords[0], (double)beforeCoords[1], (double)beforeCoords[2], beforeCoords[3], beforeCoords[4]);
                    player.field_70170_p.func_184133_a(null, player.func_180425_c(), ModSounds.TELEPORT_SFX, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    player.field_70170_p.func_184133_a(null, target.func_180425_c(), ModSounds.TELEPORT_SFX, SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
            } else if (mop instanceof BlockRayTraceResult) {
                BlockPos blockPos = ((BlockRayTraceResult)mop).func_216350_a();
                BlockState blockState = player.field_70170_p.func_180495_p(blockPos);
                FallingBlockEntity fallingBlock = new FallingBlockEntity(player.field_70170_p, (double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), blockState);
                player.field_70170_p.func_184133_a(null, fallingBlock.func_180425_c(), ModSounds.TELEPORT_SFX, SoundCategory.PLAYERS, 1.0f, 1.0f);
                if (!ability.isEntityInThisRoom((Entity)fallingBlock)) {
                    return true;
                }
                Block block = blockState.func_177230_c();
                if (GRIEF_RULE.getApprovedBlocks().stream().anyMatch(b -> block == b) && player.field_70170_p.func_72863_F().func_222865_a(new ChunkPos(blockPos))) {
                    fallingBlock = new FallingBlockEntity(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), blockState);
                    fallingBlock.func_213293_j(0.0, 0.35 + WyHelper.randomDouble() / 4.0, 0.0);
                    fallingBlock.field_70133_I = true;
                    fallingBlock.field_145812_b = 1;
                    fallingBlock.field_145813_c = false;
                    player.field_70170_p.func_217376_c((Entity)fallingBlock);
                    player.field_70170_p.func_217377_a(blockPos, false);
                    player.func_70634_a((double)blockPos.func_177958_n(), (double)(blockPos.func_177956_o() + 2), (double)blockPos.func_177952_p());
                }
                player.field_70170_p.func_184133_a(null, player.func_180425_c(), ModSounds.TELEPORT_SFX, SoundCategory.PLAYERS, 1.0f, 1.0f);
                this.setCooldown(this.getMaxCooldown() / 20.0 * 2.0);
                WyNetwork.sendToAllTrackingAndSelf(new SUpdateEquippedAbilityPacket(player, this), (LivingEntity)player);
            }
        }
        return true;
    }
}

