/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.ope;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.abilities.ope.RoomAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ContinuousAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;

public class TaktAbility
extends ContinuousAbility {
    public static final Ability INSTANCE = new TaktAbility();

    public TaktAbility() {
        super("Takt", AbilityHelper.getDevilFruitCategory());
        this.setMaxCooldown(10.0);
        this.setThreshold(6.0);
        this.setDescription("The user lifts entities its looking at, preventing them from moving freely");
        this.onStartContinuityEvent = this::onStartContinuityEvent;
        this.duringContinuityEvent = this::duringContinuity;
    }

    private boolean onStartContinuityEvent(PlayerEntity player) {
        RoomAbility ability = AbilityDataCapability.get((LivingEntity)player).getEquippedAbility(RoomAbility.INSTANCE);
        if (ability == null || !ability.isEntityInThisRoom((Entity)player)) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_ONLY_IN_ROOM, new Object[]{this.getName()}));
            return false;
        }
        return true;
    }

    private void duringContinuity(PlayerEntity player, int timer) {
        RoomAbility ability = AbilityDataCapability.get((LivingEntity)player).getEquippedAbility(RoomAbility.INSTANCE);
        if (ability == null || !ability.isEntityInThisRoom((Entity)player)) {
            this.stopContinuity(player);
            return;
        }
        RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)player, 64.0);
        List<Entity> list = WyHelper.getEntitiesNear(new BlockPos(mop.func_216347_e()), player.field_70170_p, 8.0, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), Entity.class);
        list.remove(player);
        list.removeIf(entity -> !ability.isEntityInThisRoom((Entity)entity));
        list.removeIf(entity -> entity instanceof AbilityProjectileEntity && !((AbilityProjectileEntity)((Object)entity)).isPhysical());
        list.forEach(entity -> {
            if (entity instanceof LivingEntity && (double)HakiHelper.getTotalHakiExp((LivingEntity)player) <= (double)HakiHelper.getTotalHakiExp((LivingEntity)entity) + WyHelper.randomWithRange(-3, 2)) {
                return;
            }
            entity.func_213293_j(0.0, 0.0, 0.0);
            if (entity.func_226278_cu_() <= player.func_226278_cu_() + 3.0) {
                entity.func_70634_a(entity.func_226277_ct_(), entity.func_226278_cu_() + 0.5, entity.func_226281_cx_());
            }
        });
    }
}

