/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.pika;

import java.awt.Color;
import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.api.AbilityDamageSource;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.IPunchOverlayAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ContinuousAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.IChangeDamageSourceAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.IParallelContinuousAbility;

public class LightAccelerationAbility
extends ContinuousAbility
implements IChangeDamageSourceAbility,
IPunchOverlayAbility,
IParallelContinuousAbility {
    private static final AbilityOverlay OVERLAY = new AbilityOverlay().setRenderType(AbilityOverlay.RenderType.ENERGY).setColor(new Color(255, 220, 0));
    public static final AttributeModifier ATTACK_SPEED_MODIFIER = new AttributeModifier(UUID.fromString("1d78a133-8a0e-4b8f-8790-1360007d4741"), "Attack Speed Multiplier", 4.0, AttributeModifier.Operation.ADDITION).func_111168_a(false);
    public static final Ability INSTANCE = new LightAccelerationAbility();

    public LightAccelerationAbility() {
        super("Light Acceleration", AbilityHelper.getDevilFruitCategory());
        this.setThreshold(20.0);
        this.setMaxCooldown(10.0);
        this.setDescription("The user accelerates its attacks by converting into light before impact");
        this.onStartContinuityEvent = this::onStartContinuityEvent;
        this.duringContinuityEvent = this::duringContinuityEvent;
        this.onEndContinuityEvent = this::onEndContinuity;
    }

    private boolean onStartContinuityEvent(PlayerEntity player) {
        if (!player.func_184614_ca().func_190926_b()) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_FIST, new Object[0]));
            return false;
        }
        player.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111121_a(ATTACK_SPEED_MODIFIER);
        return true;
    }

    private void duringContinuityEvent(PlayerEntity player, int i) {
        if (!player.func_184614_ca().func_190926_b()) {
            this.stopContinuity(player);
        }
    }

    private boolean onEndContinuity(PlayerEntity player) {
        player.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111124_b(ATTACK_SPEED_MODIFIER);
        return true;
    }

    @Override
    public float damageToEntityWithSource(PlayerEntity player, LivingEntity target) {
        float strength = Math.min((float)player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e(), 50.0f);
        float absorption = 0.75f;
        if (target.field_70172_ad > 0 && target.field_70172_ad <= 10) {
            target.field_70172_ad = 0;
            target.field_70737_aN = 0;
        }
        Vec3d speed = player.func_70676_i(1.0f).func_216372_d(4.0, 3.0, 4.0);
        target.func_213293_j(speed.field_72450_a, speed.field_72448_b, speed.field_72449_c);
        target.field_70133_I = true;
        target.field_70143_R = 0.0f;
        return 10.0f + strength * absorption;
    }

    @Override
    public DamageSource getSourceToUse(PlayerEntity player) {
        return new AbilityDamageSource("player", null, this);
    }

    @Override
    public boolean cancelsOriginalDamage() {
        return true;
    }

    @Override
    public boolean isSourceChangeEnabled() {
        return this.isContinuous();
    }

    @Override
    public AbilityOverlay getPunchOverlay(LivingEntity entity) {
        return entity.field_82175_bq ? OVERLAY : new AbilityOverlay().setTexture(ModResources.DOKU_COATING).setColor(new Color(255, 255, 255, 0));
    }
}

