/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.pika;

import java.awt.Color;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import xyz.pixelatedw.mineminenomi.api.abilities.IFallDamageBlockingAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.LightningEntity;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.pika.ChargingPikaParticleEvent;
import xyz.pixelatedw.mineminenomi.particles.effects.pika.YataNoKagamiParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;

public class YataNoKagamiAbility
extends ChargeableAbility
implements IFallDamageBlockingAbility {
    public static final Ability INSTANCE = new YataNoKagamiAbility();
    private static final ParticleEffect PARTICLES = new YataNoKagamiParticleEffect();
    private static final ParticleEffect CHARGE_PARTICLE = new ChargingPikaParticleEvent();
    private boolean hasFallDamage = true;
    double cooldown = 0.5;
    LightningEntity bolt = null;
    private final float maxTeleportDistance = 320.0f;
    BlockPos blockPos = null;

    public YataNoKagamiAbility() {
        super("Yata no Kagami", AbilityHelper.getDevilFruitCategory());
        this.setMaxCooldown(this.cooldown);
        this.setMaxChargeTime(1.5);
        this.setCancelable();
        this.setDescription("The user forms light between his hands, and reflects it off any surface he wishes, instantly teleporting it towards where the light hit.");
        this.duringCooldownEvent = this::duringCooldownEvent;
        this.duringChargingEvent = this::duringChargingEvent;
        this.onEndChargingEvent = this::endChargeEvent;
    }

    private void duringCooldownEvent(PlayerEntity player, int i) {
        if (this.bolt != null) {
            this.bolt.func_70106_y();
            this.bolt = null;
        }
    }

    private void duringChargingEvent(PlayerEntity player, int timer) {
        Entity entity;
        EntityRayTraceResult trace = WyHelper.rayTraceEntities((Entity)player, 1.0);
        this.blockPos = null;
        if (player.func_225608_bj_()) {
            this.stopCharging(player);
        }
        if (this.bolt == null) {
            LightningEntity bolt = new LightningEntity((Entity)player, trace.func_216347_e().field_72450_a, trace.func_216347_e().field_72448_b - (double)(player.func_70047_e() / 4.0f), trace.func_216347_e().field_72449_c, player.field_70177_z, player.field_70125_A, 320.0f, 320.0f / (float)this.getMaxChargeTime());
            bolt.setColor(new Color(255, 242, 0, 188));
            bolt.setAliveTicks((int)((double)this.getMaxChargeTime() * 1.2));
            bolt.setDamage(0.0f);
            bolt.setSize(0.04f);
            bolt.setBranches(8);
            bolt.setSegments(1);
            bolt.disableLightningMimic();
            this.bolt = bolt;
            player.field_70170_p.func_217376_c((Entity)bolt);
        }
        if (!this.bolt.firstContactBlocks.isEmpty()) {
            BlockPos pos = this.bolt.firstContactBlocks.get(0);
            this.bolt.func_70106_y();
            this.bolt = null;
            this.blockPos = pos;
            this.stopCharging(player);
            return;
        }
        if (!this.bolt.targets.isEmpty() && (entity = player.field_70170_p.func_73045_a(this.bolt.targets.get(0).intValue())) instanceof LivingEntity) {
            this.bolt.func_70106_y();
            this.bolt = null;
            EffectInstance eff = new EffectInstance(ModEffects.MOVEMENT_BLOCKED, 300, 1, false, false);
            ((LivingEntity)entity).func_195064_c(eff);
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SPlayEntityEffectPacket(player.func_145782_y(), eff));
            this.blockPos = entity.func_180425_c();
            this.stopCharging(player);
            return;
        }
        player.func_195064_c(new EffectInstance(ModEffects.MOVEMENT_BLOCKED, 5, 1, false, false));
        AbilityHelper.slowEntityFall((LivingEntity)player, 30);
        CHARGE_PARTICLE.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
    }

    private boolean endChargeEvent(PlayerEntity player) {
        if (this.getChargeTime() > this.getMaxChargeTime() - 10) {
            return false;
        }
        boolean wasNull = false;
        if (this.blockPos == null) {
            wasNull = true;
            this.blockPos = new BlockPos(WyHelper.rayTraceBlocks((Entity)player, 64.0).func_216347_e());
        } else {
            this.blockPos = WyHelper.getClearPositionForPlayer(player.field_70170_p, this.blockPos);
            if (this.blockPos == null) {
                this.setCooldown(0.0);
                return true;
            }
        }
        double x = this.blockPos.func_177958_n();
        double y = this.blockPos.func_177956_o();
        double z = this.blockPos.func_177952_p();
        if (player.func_184187_bx() != null) {
            player.func_184210_p();
        }
        if (!player.field_70170_p.func_175723_af().func_177746_a(this.blockPos)) {
            this.setMaxCooldown(0.5 + (double)(wasNull ? 3 : 0));
            return true;
        }
        PARTICLES.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
        PARTICLES.spawn(player.field_70170_p, x, y, z, 0.0, 0.0, 0.0);
        double teleportDistance = Math.sqrt(player.func_70092_e(x, y, z));
        player.func_223102_j((double)this.blockPos.func_177958_n(), (double)this.blockPos.func_177956_o(), (double)this.blockPos.func_177952_p());
        double cooldownOffset = 224 - (!player.field_70122_E ? 32 : 0) - (player.field_70172_ad > 0 ? 112 : 0);
        double cooldown = Math.max(320.0 / cooldownOffset * (teleportDistance / 320.0), 0.5) + (double)(wasNull ? 3 : 0);
        this.hasFallDamage = false;
        this.setMaxCooldown(cooldown);
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), ModSounds.PIKA_SFX, SoundCategory.PLAYERS, 1.0f, 1.0f);
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), ModSounds.TELEPORT_SFX, SoundCategory.PLAYERS, 1.0f, 1.0f);
        return true;
    }

    @Override
    public void resetFallDamage(LivingEntity player) {
        this.hasFallDamage = true;
    }

    @Override
    public boolean hasFallDamage() {
        return this.hasFallDamage;
    }
}

