/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.rokushiki;

import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SUpdateEquippedAbilityPacket;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ContinuousAbility;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

public class SoruAbility
extends ContinuousAbility {
    public static final Ability INSTANCE = new SoruAbility();
    private static final AttributeModifier STEP_HEIGHT = new AttributeModifier(UUID.fromString("1d68a133-8a0e-4b8f-8790-1360007d4741"), "Step Height Multiplier", 1.0, AttributeModifier.Operation.ADDITION).func_111168_a(false);

    public SoruAbility() {
        super("Soru", AbilityHelper.getRacialCategory());
        this.setMaxCooldown(10.0);
        this.setThreshold(2.0);
        this.setDescription("Allows the user to move at an extremely high speed for a short period");
        this.onStartContinuityEvent = this::onStartContinuityEvent;
        this.duringContinuityEvent = this::duringContinuity;
        this.onEndContinuityEvent = this::onEndContinuityEvent;
    }

    private boolean onStartContinuityEvent(PlayerEntity player) {
        if (!AbilityHelper.canUseMomentumAbility(player)) {
            return false;
        }
        if (!player.field_70122_E) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_ONLY_IN_GROUND, new Object[]{this.getName()}));
            return false;
        }
        player.func_110148_a(ModAttributes.STEP_HEIGHT).func_111124_b(STEP_HEIGHT);
        player.func_110148_a(ModAttributes.STEP_HEIGHT).func_111121_a(STEP_HEIGHT);
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), ModSounds.TELEPORT_SFX, SoundCategory.PLAYERS, 1.0f, 1.0f);
        int maxUse = 10 + (int)Math.min(Math.round((double)EntityStatsCapability.get((LivingEntity)player).getDoriki() * 0.003 / 10.0) * 10L, 30L);
        this.setThresholdInTicks(maxUse);
        WyNetwork.sendToAllTrackingAndSelf(new SUpdateEquippedAbilityPacket(player, this), (LivingEntity)player);
        return true;
    }

    private void duringContinuity(PlayerEntity player, int passiveTimer) {
        if (player.field_70123_F || player.func_70090_H()) {
            this.stopContinuity(player);
        }
        int doriki = EntityStatsCapability.get((LivingEntity)player).getDoriki();
        float maxSpeed = 1.25f + (float)((int)Math.min((double)Math.round((double)doriki * 7.5E-5), 0.75));
        Vec3d vec = player.func_70040_Z();
        if (player.field_70122_E) {
            player.func_213293_j(vec.field_72450_a * (double)maxSpeed, player.func_213322_ci().field_72448_b, vec.field_72449_c * (double)maxSpeed);
        } else {
            player.func_213293_j(doriki > 6000 ? vec.field_72450_a * (double)maxSpeed * 0.75 : player.func_213322_ci().field_72450_a, player.func_213322_ci().field_72448_b, doriki > 6000 ? vec.field_72449_c * (double)maxSpeed * 0.5 : player.func_213322_ci().field_72449_c);
        }
        player.field_70133_I = true;
    }

    private boolean onEndContinuityEvent(PlayerEntity player) {
        int cooldown = 2 + (int)Math.round((double)this.continueTime / 5.0);
        this.setMaxCooldown(cooldown);
        player.func_110148_a(ModAttributes.STEP_HEIGHT).func_111124_b(STEP_HEIGHT);
        return true;
    }
}

