/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.sui;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import xyz.pixelatedw.mineminenomi.abilities.sui.FreeSwimmingAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;

public class NekomimiPunchAbility
extends Ability {
    public static final NekomimiPunchAbility INSTANCE = new NekomimiPunchAbility();

    public NekomimiPunchAbility() {
        super("Nekomimi Punch", AbilityHelper.getDevilFruitCategory());
        this.setMaxCooldown(6.0);
        this.setDescription("Propels the swimming user forward and deals huge damage to all entities they hit");
        this.onUseEvent = this::onUseEvent;
        this.duringCooldownEvent = this::duringCooldown;
    }

    private boolean onUseEvent(PlayerEntity player) {
        if (!AbilityHelper.canUseMomentumAbility(player)) {
            return false;
        }
        IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
        if (props.getEquippedAbility(FreeSwimmingAbility.INSTANCE).isSwimming) {
            Vec3d speed = WyHelper.propulsion((LivingEntity)player, 3.0, 1.5, 3.0);
            player.func_213293_j(speed.field_72450_a, 0.5 + speed.field_72448_b, speed.field_72449_c);
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket((Entity)player));
            return true;
        }
        return false;
    }

    private void duringCooldown(PlayerEntity player, int cooldownTimer) {
        if ((double)(cooldownTimer / 20) > this.maxCooldown / 20.0 - 3.0) {
            List<LivingEntity> list = WyHelper.getEntitiesNear(player.func_180425_c(), player.field_70170_p, 1.4, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), LivingEntity.class);
            list.remove(player);
            for (LivingEntity target : list) {
                target.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), 20.0f);
            }
        }
    }
}

