/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.sui;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.Vec3d;
import xyz.pixelatedw.mineminenomi.abilities.sui.FreeSwimmingAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.common.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;

public class NyanNyanSuplexAbility
extends ChargeableAbility {
    public static final NyanNyanSuplexAbility INSTANCE = new NyanNyanSuplexAbility();
    private LivingEntity grabbedEntity = null;

    public NyanNyanSuplexAbility() {
        super("Nyan Nyan Suplex", AbilityHelper.getDevilFruitCategory());
        this.setDescription("While swimming, grabs an opponent from the back and launches them into the ground, dealing moderate damage and creating a small crater");
        this.setMaxCooldown(10.0);
        this.setMaxChargeTime(2.0);
        this.onStartChargingEvent = this::onUseEvent;
        this.duringChargingEvent = this::duringChargingEvent;
        this.onEndChargingEvent = this::onEndChargingEvent;
    }

    private boolean onUseEvent(PlayerEntity player) {
        this.grabbedEntity = null;
        FreeSwimmingAbility ability = AbilityDataCapability.get((LivingEntity)player).getEquippedAbility(FreeSwimmingAbility.INSTANCE);
        if (ability != null && ability.isSwimming) {
            List list = WyHelper.getEntitiesNearSphere(player.func_180425_c(), player.field_70170_p, 1.2, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), LivingEntity.class);
            list.remove(player);
            list.removeIf(entity -> AbilityHelper.isTargetBlockingAbility(player, entity));
            if (!HakiHelper.hasHardeningActive((LivingEntity)player)) {
                list.removeIf(entity -> DevilFruitCapability.get(entity).isLogia());
            }
            this.grabbedEntity = list.size() > 0 ? (LivingEntity)list.get(0) : null;
            return list.size() > 0;
        }
        return false;
    }

    private void duringChargingEvent(PlayerEntity player, int chargeTimer) {
        boolean isActive;
        if (!this.grabbedEntity.func_70089_S() || DevilFruitCapability.get(this.grabbedEntity).isLogia() && !HakiHelper.hasHardeningActive((LivingEntity)player) || AbilityHelper.isTargetBlockingAbility(player, this.grabbedEntity)) {
            this.stopCharging(player);
        }
        this.grabbedEntity.func_195064_c(new EffectInstance(ModEffects.MOVEMENT_BLOCKED, 20, 0));
        FreeSwimmingAbility ability = AbilityDataCapability.get((LivingEntity)player).getEquippedAbility(FreeSwimmingAbility.INSTANCE);
        boolean bl = isActive = ability != null && ability.isContinuous();
        if (isActive) {
            ability.stopContinuity(player);
        }
        float distance = 1.0f;
        Vec3d lookVec = this.grabbedEntity.func_70040_Z();
        Vec3d pos = new Vec3d(this.grabbedEntity.func_226277_ct_() - lookVec.field_72450_a * (double)distance, this.grabbedEntity.func_226278_cu_(), this.grabbedEntity.func_226281_cx_() - lookVec.field_72449_c * (double)distance);
        player.func_70634_a(pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c());
    }

    private boolean onEndChargingEvent(PlayerEntity player) {
        if (this.grabbedEntity == null || this.getChargeTime() >= this.getMaxChargeTime()) {
            return false;
        }
        this.grabbedEntity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), 10.0f);
        ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)player, player.field_70170_p, this.grabbedEntity.func_226277_ct_(), this.grabbedEntity.func_226278_cu_(), this.grabbedEntity.func_226281_cx_(), 2.0f);
        explosion.setStaticDamage(30.0f);
        explosion.setExplosionSound(true);
        explosion.setDamageOwner(false);
        explosion.setDestroyBlocks(true);
        explosion.setFireAfterExplosion(false);
        explosion.setSmokeParticles(new CommonExplosionParticleEffect(2));
        explosion.setDamageEntities(true);
        explosion.doExplosion();
        return true;
    }
}

